<?php
/**
 * InputTrack
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Models;

use \ArrayAccess;
use \MuxPhp\ObjectSerializer;

/**
 * InputTrack Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class InputTrack implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'InputTrack';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'type' => 'string',
        'duration' => 'double',
        'encoding' => 'string',
        'width' => 'int',
        'height' => 'int',
        'frame_rate' => 'double',
        'sample_rate' => 'int',
        'sample_size' => 'int',
        'channels' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'type' => null,
        'duration' => 'double',
        'encoding' => null,
        'width' => 'int64',
        'height' => 'int64',
        'frame_rate' => 'double',
        'sample_rate' => 'int64',
        'sample_size' => 'int64',
        'channels' => 'int64'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'type' => false,
        'duration' => false,
        'encoding' => false,
        'width' => false,
        'height' => false,
        'frame_rate' => false,
        'sample_rate' => false,
        'sample_size' => false,
        'channels' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'type',
        'duration' => 'duration',
        'encoding' => 'encoding',
        'width' => 'width',
        'height' => 'height',
        'frame_rate' => 'frame_rate',
        'sample_rate' => 'sample_rate',
        'sample_size' => 'sample_size',
        'channels' => 'channels'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'type' => 'setType',
        'duration' => 'setDuration',
        'encoding' => 'setEncoding',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'frame_rate' => 'setFrameRate',
        'sample_rate' => 'setSampleRate',
        'sample_size' => 'setSampleSize',
        'channels' => 'setChannels'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'duration' => 'getDuration',
        'encoding' => 'getEncoding',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'frame_rate' => 'getFrameRate',
        'sample_rate' => 'getSampleRate',
        'sample_size' => 'getSampleSize',
        'channels' => 'getChannels'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        // MUX: enum hack (self::) due to OAS emitting problems.
        //      please re-integrate with mainline when possible.
        //      src: https://github.com/OpenAPITools/openapi-generator/issues/9038
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('duration', $data ?? [], null);
        $this->setIfExists('encoding', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('frame_rate', $data ?? [], null);
        $this->setIfExists('sample_rate', $data ?? [], null);
        $this->setIfExists('sample_size', $data ?? [], null);
        $this->setIfExists('channels', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {

        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }

        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets duration
     *
     * @return double|null
     */
    public function getDuration()
    {
        return $this->container['duration'];
    }

    /**
     * Sets duration
     *
     * @param double|null $duration duration
     *
     * @return self
     */
    public function setDuration($duration)
    {

        if (is_null($duration)) {
            throw new \InvalidArgumentException('non-nullable duration cannot be null');
        }

        $this->container['duration'] = $duration;

        return $this;
    }

    /**
     * Gets encoding
     *
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->container['encoding'];
    }

    /**
     * Sets encoding
     *
     * @param string|null $encoding encoding
     *
     * @return self
     */
    public function setEncoding($encoding)
    {

        if (is_null($encoding)) {
            throw new \InvalidArgumentException('non-nullable encoding cannot be null');
        }

        $this->container['encoding'] = $encoding;

        return $this;
    }

    /**
     * Gets width
     *
     * @return int|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param int|null $width width
     *
     * @return self
     */
    public function setWidth($width)
    {

        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }

        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return int|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param int|null $height height
     *
     * @return self
     */
    public function setHeight($height)
    {

        if (is_null($height)) {
            throw new \InvalidArgumentException('non-nullable height cannot be null');
        }

        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets frame_rate
     *
     * @return double|null
     */
    public function getFrameRate()
    {
        return $this->container['frame_rate'];
    }

    /**
     * Sets frame_rate
     *
     * @param double|null $frame_rate frame_rate
     *
     * @return self
     */
    public function setFrameRate($frame_rate)
    {

        if (is_null($frame_rate)) {
            throw new \InvalidArgumentException('non-nullable frame_rate cannot be null');
        }

        $this->container['frame_rate'] = $frame_rate;

        return $this;
    }

    /**
     * Gets sample_rate
     *
     * @return int|null
     */
    public function getSampleRate()
    {
        return $this->container['sample_rate'];
    }

    /**
     * Sets sample_rate
     *
     * @param int|null $sample_rate sample_rate
     *
     * @return self
     */
    public function setSampleRate($sample_rate)
    {

        if (is_null($sample_rate)) {
            throw new \InvalidArgumentException('non-nullable sample_rate cannot be null');
        }

        $this->container['sample_rate'] = $sample_rate;

        return $this;
    }

    /**
     * Gets sample_size
     *
     * @return int|null
     */
    public function getSampleSize()
    {
        return $this->container['sample_size'];
    }

    /**
     * Sets sample_size
     *
     * @param int|null $sample_size sample_size
     *
     * @return self
     */
    public function setSampleSize($sample_size)
    {

        if (is_null($sample_size)) {
            throw new \InvalidArgumentException('non-nullable sample_size cannot be null');
        }

        $this->container['sample_size'] = $sample_size;

        return $this;
    }

    /**
     * Gets channels
     *
     * @return int|null
     */
    public function getChannels()
    {
        return $this->container['channels'];
    }

    /**
     * Sets channels
     *
     * @param int|null $channels channels
     *
     * @return self
     */
    public function setChannels($channels)
    {

        if (is_null($channels)) {
            throw new \InvalidArgumentException('non-nullable channels cannot be null');
        }

        $this->container['channels'] = $channels;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


