<?php
/**
 * VideoView
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Models;

use \ArrayAccess;
use \MuxPhp\ObjectSerializer;

/**
 * VideoView Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class VideoView implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'VideoView';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'view_total_upscaling' => 'string',
        'preroll_ad_asset_hostname' => 'string',
        'player_source_domain' => 'string',
        'region' => 'string',
        'viewer_user_agent' => 'string',
        'preroll_requested' => 'bool',
        'page_type' => 'string',
        'startup_score' => 'string',
        'view_seek_duration' => 'int',
        'country_name' => 'string',
        'player_source_height' => 'int',
        'longitude' => 'string',
        'buffering_count' => 'int',
        'video_duration' => 'int',
        'player_source_type' => 'string',
        'city' => 'string',
        'view_id' => 'string',
        'platform_description' => 'string',
        'video_startup_preroll_request_time' => 'int',
        'viewer_device_name' => 'string',
        'video_series' => 'string',
        'viewer_application_name' => 'string',
        'updated_at' => 'string',
        'view_total_content_playback_time' => 'int',
        'cdn' => 'string',
        'player_instance_id' => 'string',
        'video_language' => 'string',
        'player_source_width' => 'int',
        'player_error_message' => 'string',
        'player_mux_plugin_version' => 'string',
        'watched' => 'bool',
        'playback_score' => 'string',
        'page_url' => 'string',
        'metro' => 'string',
        'view_max_request_latency' => 'int',
        'requests_for_first_preroll' => 'int',
        'view_total_downscaling' => 'string',
        'latitude' => 'string',
        'player_source_host_name' => 'string',
        'inserted_at' => 'string',
        'view_end' => 'string',
        'mux_embed_version' => 'string',
        'player_language' => 'string',
        'page_load_time' => 'int',
        'viewer_device_category' => 'string',
        'video_startup_preroll_load_time' => 'int',
        'player_version' => 'string',
        'watch_time' => 'int',
        'player_source_stream_type' => 'string',
        'preroll_ad_tag_hostname' => 'string',
        'viewer_device_manufacturer' => 'string',
        'rebuffering_score' => 'string',
        'experiment_name' => 'string',
        'viewer_os_version' => 'string',
        'player_preload' => 'bool',
        'buffering_duration' => 'int',
        'player_view_count' => 'int',
        'player_software' => 'string',
        'player_load_time' => 'int',
        'platform_summary' => 'string',
        'video_encoding_variant' => 'string',
        'player_width' => 'int',
        'view_seek_count' => 'int',
        'viewer_experience_score' => 'string',
        'view_error_id' => 'int',
        'video_variant_name' => 'string',
        'preroll_played' => 'bool',
        'viewer_application_engine' => 'string',
        'viewer_os_architecture' => 'string',
        'player_error_code' => 'string',
        'buffering_rate' => 'string',
        'events' => '\MuxPhp\Models\VideoViewEvent[]',
        'player_name' => 'string',
        'view_start' => 'string',
        'view_average_request_throughput' => 'int',
        'video_producer' => 'string',
        'error_type_id' => 'int',
        'mux_viewer_id' => 'string',
        'video_id' => 'string',
        'continent_code' => 'string',
        'session_id' => 'string',
        'exit_before_video_start' => 'bool',
        'video_content_type' => 'string',
        'viewer_os_family' => 'string',
        'player_poster' => 'string',
        'view_average_request_latency' => 'int',
        'video_variant_id' => 'string',
        'player_source_duration' => 'int',
        'player_source_url' => 'string',
        'mux_api_version' => 'string',
        'video_title' => 'string',
        'id' => 'string',
        'short_time' => 'string',
        'rebuffer_percentage' => 'string',
        'time_to_first_frame' => 'int',
        'viewer_user_id' => 'string',
        'video_stream_type' => 'string',
        'player_startup_time' => 'int',
        'viewer_application_version' => 'string',
        'view_max_downscale_percentage' => 'string',
        'view_max_upscale_percentage' => 'string',
        'country_code' => 'string',
        'used_fullscreen' => 'bool',
        'isp' => 'string',
        'property_id' => 'int',
        'player_autoplay' => 'bool',
        'player_height' => 'int',
        'asn' => 'int',
        'asn_name' => 'string',
        'quality_score' => 'string',
        'player_software_version' => 'string',
        'player_mux_plugin_name' => 'string',
        'sub_property_id' => 'string',
        'player_remote_played' => 'bool',
        'view_max_playhead_position' => 'string',
        'view_playing_time' => 'string',
        'view_session_id' => 'string',
        'viewer_connection_type' => 'string',
        'viewer_device_model' => 'string',
        'weighted_average_bitrate' => 'double',
        'custom_1' => 'string',
        'custom_2' => 'string',
        'custom_3' => 'string',
        'custom_4' => 'string',
        'custom_5' => 'string',
        'custom_6' => 'string',
        'custom_7' => 'string',
        'custom_8' => 'string',
        'custom_9' => 'string',
        'custom_10' => 'string',
        'live_stream_latency' => 'int',
        'asset_id' => 'string',
        'environment_id' => 'string',
        'live_stream_id' => 'string',
        'mux_embed' => 'string',
        'playback_id' => 'string',
        'player_error_context' => 'string',
        'view_drm_type' => 'string',
        'view_dropped_frame_count' => 'int',
        'view_has_ad' => 'bool',
        'video_startup_failure' => 'bool',
        'ad_attempt_count' => 'int',
        'ad_break_count' => 'int',
        'ad_break_error_count' => 'int',
        'ad_break_error_percentage' => 'string',
        'ad_error_count' => 'int',
        'ad_error_percentage' => 'string',
        'ad_impression_count' => 'int',
        'ad_startup_error_count' => 'int',
        'ad_startup_error_percentage' => 'string',
        'ad_exit_before_start_count' => 'int',
        'ad_exit_before_start_percentage' => 'string',
        'long_resume' => 'bool',
        'long_rebuffering' => 'bool',
        'playback_failure_error_type_id' => 'int',
        'playback_business_exception_error_type_id' => 'int',
        'video_startup_business_exception_error_type_id' => 'int',
        'playback_failure' => 'bool',
        'ad_playback_failure_error_type_id' => 'int',
        'view_content_startup_time' => 'int',
        'ad_preroll_startup_time' => 'int',
        'ad_watch_time' => 'int',
        'view_content_watch_time' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'view_total_upscaling' => null,
        'preroll_ad_asset_hostname' => null,
        'player_source_domain' => null,
        'region' => null,
        'viewer_user_agent' => null,
        'preroll_requested' => null,
        'page_type' => null,
        'startup_score' => null,
        'view_seek_duration' => 'int64',
        'country_name' => null,
        'player_source_height' => 'int32',
        'longitude' => null,
        'buffering_count' => 'int64',
        'video_duration' => 'int64',
        'player_source_type' => null,
        'city' => null,
        'view_id' => null,
        'platform_description' => null,
        'video_startup_preroll_request_time' => 'int64',
        'viewer_device_name' => null,
        'video_series' => null,
        'viewer_application_name' => null,
        'updated_at' => null,
        'view_total_content_playback_time' => 'int64',
        'cdn' => null,
        'player_instance_id' => null,
        'video_language' => null,
        'player_source_width' => 'int32',
        'player_error_message' => null,
        'player_mux_plugin_version' => null,
        'watched' => null,
        'playback_score' => null,
        'page_url' => null,
        'metro' => null,
        'view_max_request_latency' => 'int64',
        'requests_for_first_preroll' => 'int64',
        'view_total_downscaling' => null,
        'latitude' => null,
        'player_source_host_name' => null,
        'inserted_at' => null,
        'view_end' => null,
        'mux_embed_version' => null,
        'player_language' => null,
        'page_load_time' => 'int64',
        'viewer_device_category' => null,
        'video_startup_preroll_load_time' => 'int64',
        'player_version' => null,
        'watch_time' => 'int64',
        'player_source_stream_type' => null,
        'preroll_ad_tag_hostname' => null,
        'viewer_device_manufacturer' => null,
        'rebuffering_score' => null,
        'experiment_name' => null,
        'viewer_os_version' => null,
        'player_preload' => null,
        'buffering_duration' => 'int64',
        'player_view_count' => 'int64',
        'player_software' => null,
        'player_load_time' => 'int64',
        'platform_summary' => null,
        'video_encoding_variant' => null,
        'player_width' => 'int32',
        'view_seek_count' => 'int64',
        'viewer_experience_score' => null,
        'view_error_id' => 'int32',
        'video_variant_name' => null,
        'preroll_played' => null,
        'viewer_application_engine' => null,
        'viewer_os_architecture' => null,
        'player_error_code' => null,
        'buffering_rate' => null,
        'events' => null,
        'player_name' => null,
        'view_start' => null,
        'view_average_request_throughput' => 'int64',
        'video_producer' => null,
        'error_type_id' => 'int32',
        'mux_viewer_id' => null,
        'video_id' => null,
        'continent_code' => null,
        'session_id' => null,
        'exit_before_video_start' => null,
        'video_content_type' => null,
        'viewer_os_family' => null,
        'player_poster' => null,
        'view_average_request_latency' => 'int64',
        'video_variant_id' => null,
        'player_source_duration' => 'int64',
        'player_source_url' => null,
        'mux_api_version' => null,
        'video_title' => null,
        'id' => null,
        'short_time' => null,
        'rebuffer_percentage' => null,
        'time_to_first_frame' => 'int64',
        'viewer_user_id' => null,
        'video_stream_type' => null,
        'player_startup_time' => 'int64',
        'viewer_application_version' => null,
        'view_max_downscale_percentage' => null,
        'view_max_upscale_percentage' => null,
        'country_code' => null,
        'used_fullscreen' => null,
        'isp' => null,
        'property_id' => 'int64',
        'player_autoplay' => null,
        'player_height' => 'int32',
        'asn' => 'int64',
        'asn_name' => null,
        'quality_score' => null,
        'player_software_version' => null,
        'player_mux_plugin_name' => null,
        'sub_property_id' => null,
        'player_remote_played' => null,
        'view_max_playhead_position' => null,
        'view_playing_time' => null,
        'view_session_id' => null,
        'viewer_connection_type' => null,
        'viewer_device_model' => null,
        'weighted_average_bitrate' => 'double',
        'custom_1' => null,
        'custom_2' => null,
        'custom_3' => null,
        'custom_4' => null,
        'custom_5' => null,
        'custom_6' => null,
        'custom_7' => null,
        'custom_8' => null,
        'custom_9' => null,
        'custom_10' => null,
        'live_stream_latency' => 'int64',
        'asset_id' => null,
        'environment_id' => null,
        'live_stream_id' => null,
        'mux_embed' => null,
        'playback_id' => null,
        'player_error_context' => null,
        'view_drm_type' => null,
        'view_dropped_frame_count' => 'int64',
        'view_has_ad' => null,
        'video_startup_failure' => null,
        'ad_attempt_count' => 'int32',
        'ad_break_count' => 'int32',
        'ad_break_error_count' => 'int32',
        'ad_break_error_percentage' => null,
        'ad_error_count' => 'int32',
        'ad_error_percentage' => null,
        'ad_impression_count' => 'int32',
        'ad_startup_error_count' => 'int32',
        'ad_startup_error_percentage' => null,
        'ad_exit_before_start_count' => 'int32',
        'ad_exit_before_start_percentage' => null,
        'long_resume' => null,
        'long_rebuffering' => null,
        'playback_failure_error_type_id' => 'int32',
        'playback_business_exception_error_type_id' => 'int32',
        'video_startup_business_exception_error_type_id' => 'int32',
        'playback_failure' => null,
        'ad_playback_failure_error_type_id' => 'int32',
        'view_content_startup_time' => 'int32',
        'ad_preroll_startup_time' => 'int32',
        'ad_watch_time' => 'int32',
        'view_content_watch_time' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'view_total_upscaling' => true,
        'preroll_ad_asset_hostname' => true,
        'player_source_domain' => true,
        'region' => true,
        'viewer_user_agent' => true,
        'preroll_requested' => true,
        'page_type' => true,
        'startup_score' => true,
        'view_seek_duration' => true,
        'country_name' => true,
        'player_source_height' => true,
        'longitude' => true,
        'buffering_count' => true,
        'video_duration' => true,
        'player_source_type' => true,
        'city' => true,
        'view_id' => false,
        'platform_description' => true,
        'video_startup_preroll_request_time' => true,
        'viewer_device_name' => true,
        'video_series' => true,
        'viewer_application_name' => true,
        'updated_at' => false,
        'view_total_content_playback_time' => true,
        'cdn' => true,
        'player_instance_id' => true,
        'video_language' => true,
        'player_source_width' => true,
        'player_error_message' => true,
        'player_mux_plugin_version' => true,
        'watched' => false,
        'playback_score' => true,
        'page_url' => true,
        'metro' => true,
        'view_max_request_latency' => true,
        'requests_for_first_preroll' => true,
        'view_total_downscaling' => true,
        'latitude' => true,
        'player_source_host_name' => true,
        'inserted_at' => false,
        'view_end' => false,
        'mux_embed_version' => true,
        'player_language' => true,
        'page_load_time' => true,
        'viewer_device_category' => true,
        'video_startup_preroll_load_time' => true,
        'player_version' => true,
        'watch_time' => true,
        'player_source_stream_type' => true,
        'preroll_ad_tag_hostname' => true,
        'viewer_device_manufacturer' => true,
        'rebuffering_score' => true,
        'experiment_name' => true,
        'viewer_os_version' => true,
        'player_preload' => false,
        'buffering_duration' => true,
        'player_view_count' => true,
        'player_software' => true,
        'player_load_time' => true,
        'platform_summary' => true,
        'video_encoding_variant' => true,
        'player_width' => true,
        'view_seek_count' => true,
        'viewer_experience_score' => true,
        'view_error_id' => true,
        'video_variant_name' => true,
        'preroll_played' => true,
        'viewer_application_engine' => true,
        'viewer_os_architecture' => true,
        'player_error_code' => true,
        'buffering_rate' => true,
        'events' => false,
        'player_name' => true,
        'view_start' => false,
        'view_average_request_throughput' => true,
        'video_producer' => true,
        'error_type_id' => true,
        'mux_viewer_id' => false,
        'video_id' => true,
        'continent_code' => true,
        'session_id' => false,
        'exit_before_video_start' => false,
        'video_content_type' => true,
        'viewer_os_family' => true,
        'player_poster' => true,
        'view_average_request_latency' => true,
        'video_variant_id' => true,
        'player_source_duration' => true,
        'player_source_url' => true,
        'mux_api_version' => false,
        'video_title' => true,
        'id' => false,
        'short_time' => false,
        'rebuffer_percentage' => true,
        'time_to_first_frame' => true,
        'viewer_user_id' => true,
        'video_stream_type' => true,
        'player_startup_time' => true,
        'viewer_application_version' => true,
        'view_max_downscale_percentage' => true,
        'view_max_upscale_percentage' => true,
        'country_code' => true,
        'used_fullscreen' => false,
        'isp' => true,
        'property_id' => false,
        'player_autoplay' => false,
        'player_height' => true,
        'asn' => true,
        'asn_name' => true,
        'quality_score' => true,
        'player_software_version' => true,
        'player_mux_plugin_name' => true,
        'sub_property_id' => true,
        'player_remote_played' => true,
        'view_max_playhead_position' => true,
        'view_playing_time' => true,
        'view_session_id' => true,
        'viewer_connection_type' => true,
        'viewer_device_model' => true,
        'weighted_average_bitrate' => true,
        'custom_1' => true,
        'custom_2' => true,
        'custom_3' => true,
        'custom_4' => true,
        'custom_5' => true,
        'custom_6' => true,
        'custom_7' => true,
        'custom_8' => true,
        'custom_9' => true,
        'custom_10' => true,
        'live_stream_latency' => true,
        'asset_id' => true,
        'environment_id' => false,
        'live_stream_id' => true,
        'mux_embed' => true,
        'playback_id' => true,
        'player_error_context' => true,
        'view_drm_type' => true,
        'view_dropped_frame_count' => true,
        'view_has_ad' => false,
        'video_startup_failure' => false,
        'ad_attempt_count' => true,
        'ad_break_count' => true,
        'ad_break_error_count' => true,
        'ad_break_error_percentage' => true,
        'ad_error_count' => true,
        'ad_error_percentage' => true,
        'ad_impression_count' => true,
        'ad_startup_error_count' => true,
        'ad_startup_error_percentage' => true,
        'ad_exit_before_start_count' => true,
        'ad_exit_before_start_percentage' => true,
        'long_resume' => false,
        'long_rebuffering' => false,
        'playback_failure_error_type_id' => true,
        'playback_business_exception_error_type_id' => true,
        'video_startup_business_exception_error_type_id' => true,
        'playback_failure' => false,
        'ad_playback_failure_error_type_id' => true,
        'view_content_startup_time' => true,
        'ad_preroll_startup_time' => true,
        'ad_watch_time' => true,
        'view_content_watch_time' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'view_total_upscaling' => 'view_total_upscaling',
        'preroll_ad_asset_hostname' => 'preroll_ad_asset_hostname',
        'player_source_domain' => 'player_source_domain',
        'region' => 'region',
        'viewer_user_agent' => 'viewer_user_agent',
        'preroll_requested' => 'preroll_requested',
        'page_type' => 'page_type',
        'startup_score' => 'startup_score',
        'view_seek_duration' => 'view_seek_duration',
        'country_name' => 'country_name',
        'player_source_height' => 'player_source_height',
        'longitude' => 'longitude',
        'buffering_count' => 'buffering_count',
        'video_duration' => 'video_duration',
        'player_source_type' => 'player_source_type',
        'city' => 'city',
        'view_id' => 'view_id',
        'platform_description' => 'platform_description',
        'video_startup_preroll_request_time' => 'video_startup_preroll_request_time',
        'viewer_device_name' => 'viewer_device_name',
        'video_series' => 'video_series',
        'viewer_application_name' => 'viewer_application_name',
        'updated_at' => 'updated_at',
        'view_total_content_playback_time' => 'view_total_content_playback_time',
        'cdn' => 'cdn',
        'player_instance_id' => 'player_instance_id',
        'video_language' => 'video_language',
        'player_source_width' => 'player_source_width',
        'player_error_message' => 'player_error_message',
        'player_mux_plugin_version' => 'player_mux_plugin_version',
        'watched' => 'watched',
        'playback_score' => 'playback_score',
        'page_url' => 'page_url',
        'metro' => 'metro',
        'view_max_request_latency' => 'view_max_request_latency',
        'requests_for_first_preroll' => 'requests_for_first_preroll',
        'view_total_downscaling' => 'view_total_downscaling',
        'latitude' => 'latitude',
        'player_source_host_name' => 'player_source_host_name',
        'inserted_at' => 'inserted_at',
        'view_end' => 'view_end',
        'mux_embed_version' => 'mux_embed_version',
        'player_language' => 'player_language',
        'page_load_time' => 'page_load_time',
        'viewer_device_category' => 'viewer_device_category',
        'video_startup_preroll_load_time' => 'video_startup_preroll_load_time',
        'player_version' => 'player_version',
        'watch_time' => 'watch_time',
        'player_source_stream_type' => 'player_source_stream_type',
        'preroll_ad_tag_hostname' => 'preroll_ad_tag_hostname',
        'viewer_device_manufacturer' => 'viewer_device_manufacturer',
        'rebuffering_score' => 'rebuffering_score',
        'experiment_name' => 'experiment_name',
        'viewer_os_version' => 'viewer_os_version',
        'player_preload' => 'player_preload',
        'buffering_duration' => 'buffering_duration',
        'player_view_count' => 'player_view_count',
        'player_software' => 'player_software',
        'player_load_time' => 'player_load_time',
        'platform_summary' => 'platform_summary',
        'video_encoding_variant' => 'video_encoding_variant',
        'player_width' => 'player_width',
        'view_seek_count' => 'view_seek_count',
        'viewer_experience_score' => 'viewer_experience_score',
        'view_error_id' => 'view_error_id',
        'video_variant_name' => 'video_variant_name',
        'preroll_played' => 'preroll_played',
        'viewer_application_engine' => 'viewer_application_engine',
        'viewer_os_architecture' => 'viewer_os_architecture',
        'player_error_code' => 'player_error_code',
        'buffering_rate' => 'buffering_rate',
        'events' => 'events',
        'player_name' => 'player_name',
        'view_start' => 'view_start',
        'view_average_request_throughput' => 'view_average_request_throughput',
        'video_producer' => 'video_producer',
        'error_type_id' => 'error_type_id',
        'mux_viewer_id' => 'mux_viewer_id',
        'video_id' => 'video_id',
        'continent_code' => 'continent_code',
        'session_id' => 'session_id',
        'exit_before_video_start' => 'exit_before_video_start',
        'video_content_type' => 'video_content_type',
        'viewer_os_family' => 'viewer_os_family',
        'player_poster' => 'player_poster',
        'view_average_request_latency' => 'view_average_request_latency',
        'video_variant_id' => 'video_variant_id',
        'player_source_duration' => 'player_source_duration',
        'player_source_url' => 'player_source_url',
        'mux_api_version' => 'mux_api_version',
        'video_title' => 'video_title',
        'id' => 'id',
        'short_time' => 'short_time',
        'rebuffer_percentage' => 'rebuffer_percentage',
        'time_to_first_frame' => 'time_to_first_frame',
        'viewer_user_id' => 'viewer_user_id',
        'video_stream_type' => 'video_stream_type',
        'player_startup_time' => 'player_startup_time',
        'viewer_application_version' => 'viewer_application_version',
        'view_max_downscale_percentage' => 'view_max_downscale_percentage',
        'view_max_upscale_percentage' => 'view_max_upscale_percentage',
        'country_code' => 'country_code',
        'used_fullscreen' => 'used_fullscreen',
        'isp' => 'isp',
        'property_id' => 'property_id',
        'player_autoplay' => 'player_autoplay',
        'player_height' => 'player_height',
        'asn' => 'asn',
        'asn_name' => 'asn_name',
        'quality_score' => 'quality_score',
        'player_software_version' => 'player_software_version',
        'player_mux_plugin_name' => 'player_mux_plugin_name',
        'sub_property_id' => 'sub_property_id',
        'player_remote_played' => 'player_remote_played',
        'view_max_playhead_position' => 'view_max_playhead_position',
        'view_playing_time' => 'view_playing_time',
        'view_session_id' => 'view_session_id',
        'viewer_connection_type' => 'viewer_connection_type',
        'viewer_device_model' => 'viewer_device_model',
        'weighted_average_bitrate' => 'weighted_average_bitrate',
        'custom_1' => 'custom_1',
        'custom_2' => 'custom_2',
        'custom_3' => 'custom_3',
        'custom_4' => 'custom_4',
        'custom_5' => 'custom_5',
        'custom_6' => 'custom_6',
        'custom_7' => 'custom_7',
        'custom_8' => 'custom_8',
        'custom_9' => 'custom_9',
        'custom_10' => 'custom_10',
        'live_stream_latency' => 'live_stream_latency',
        'asset_id' => 'asset_id',
        'environment_id' => 'environment_id',
        'live_stream_id' => 'live_stream_id',
        'mux_embed' => 'mux_embed',
        'playback_id' => 'playback_id',
        'player_error_context' => 'player_error_context',
        'view_drm_type' => 'view_drm_type',
        'view_dropped_frame_count' => 'view_dropped_frame_count',
        'view_has_ad' => 'view_has_ad',
        'video_startup_failure' => 'video_startup_failure',
        'ad_attempt_count' => 'ad_attempt_count',
        'ad_break_count' => 'ad_break_count',
        'ad_break_error_count' => 'ad_break_error_count',
        'ad_break_error_percentage' => 'ad_break_error_percentage',
        'ad_error_count' => 'ad_error_count',
        'ad_error_percentage' => 'ad_error_percentage',
        'ad_impression_count' => 'ad_impression_count',
        'ad_startup_error_count' => 'ad_startup_error_count',
        'ad_startup_error_percentage' => 'ad_startup_error_percentage',
        'ad_exit_before_start_count' => 'ad_exit_before_start_count',
        'ad_exit_before_start_percentage' => 'ad_exit_before_start_percentage',
        'long_resume' => 'long_resume',
        'long_rebuffering' => 'long_rebuffering',
        'playback_failure_error_type_id' => 'playback_failure_error_type_id',
        'playback_business_exception_error_type_id' => 'playback_business_exception_error_type_id',
        'video_startup_business_exception_error_type_id' => 'video_startup_business_exception_error_type_id',
        'playback_failure' => 'playback_failure',
        'ad_playback_failure_error_type_id' => 'ad_playback_failure_error_type_id',
        'view_content_startup_time' => 'view_content_startup_time',
        'ad_preroll_startup_time' => 'ad_preroll_startup_time',
        'ad_watch_time' => 'ad_watch_time',
        'view_content_watch_time' => 'view_content_watch_time'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'view_total_upscaling' => 'setViewTotalUpscaling',
        'preroll_ad_asset_hostname' => 'setPrerollAdAssetHostname',
        'player_source_domain' => 'setPlayerSourceDomain',
        'region' => 'setRegion',
        'viewer_user_agent' => 'setViewerUserAgent',
        'preroll_requested' => 'setPrerollRequested',
        'page_type' => 'setPageType',
        'startup_score' => 'setStartupScore',
        'view_seek_duration' => 'setViewSeekDuration',
        'country_name' => 'setCountryName',
        'player_source_height' => 'setPlayerSourceHeight',
        'longitude' => 'setLongitude',
        'buffering_count' => 'setBufferingCount',
        'video_duration' => 'setVideoDuration',
        'player_source_type' => 'setPlayerSourceType',
        'city' => 'setCity',
        'view_id' => 'setViewId',
        'platform_description' => 'setPlatformDescription',
        'video_startup_preroll_request_time' => 'setVideoStartupPrerollRequestTime',
        'viewer_device_name' => 'setViewerDeviceName',
        'video_series' => 'setVideoSeries',
        'viewer_application_name' => 'setViewerApplicationName',
        'updated_at' => 'setUpdatedAt',
        'view_total_content_playback_time' => 'setViewTotalContentPlaybackTime',
        'cdn' => 'setCdn',
        'player_instance_id' => 'setPlayerInstanceId',
        'video_language' => 'setVideoLanguage',
        'player_source_width' => 'setPlayerSourceWidth',
        'player_error_message' => 'setPlayerErrorMessage',
        'player_mux_plugin_version' => 'setPlayerMuxPluginVersion',
        'watched' => 'setWatched',
        'playback_score' => 'setPlaybackScore',
        'page_url' => 'setPageUrl',
        'metro' => 'setMetro',
        'view_max_request_latency' => 'setViewMaxRequestLatency',
        'requests_for_first_preroll' => 'setRequestsForFirstPreroll',
        'view_total_downscaling' => 'setViewTotalDownscaling',
        'latitude' => 'setLatitude',
        'player_source_host_name' => 'setPlayerSourceHostName',
        'inserted_at' => 'setInsertedAt',
        'view_end' => 'setViewEnd',
        'mux_embed_version' => 'setMuxEmbedVersion',
        'player_language' => 'setPlayerLanguage',
        'page_load_time' => 'setPageLoadTime',
        'viewer_device_category' => 'setViewerDeviceCategory',
        'video_startup_preroll_load_time' => 'setVideoStartupPrerollLoadTime',
        'player_version' => 'setPlayerVersion',
        'watch_time' => 'setWatchTime',
        'player_source_stream_type' => 'setPlayerSourceStreamType',
        'preroll_ad_tag_hostname' => 'setPrerollAdTagHostname',
        'viewer_device_manufacturer' => 'setViewerDeviceManufacturer',
        'rebuffering_score' => 'setRebufferingScore',
        'experiment_name' => 'setExperimentName',
        'viewer_os_version' => 'setViewerOsVersion',
        'player_preload' => 'setPlayerPreload',
        'buffering_duration' => 'setBufferingDuration',
        'player_view_count' => 'setPlayerViewCount',
        'player_software' => 'setPlayerSoftware',
        'player_load_time' => 'setPlayerLoadTime',
        'platform_summary' => 'setPlatformSummary',
        'video_encoding_variant' => 'setVideoEncodingVariant',
        'player_width' => 'setPlayerWidth',
        'view_seek_count' => 'setViewSeekCount',
        'viewer_experience_score' => 'setViewerExperienceScore',
        'view_error_id' => 'setViewErrorId',
        'video_variant_name' => 'setVideoVariantName',
        'preroll_played' => 'setPrerollPlayed',
        'viewer_application_engine' => 'setViewerApplicationEngine',
        'viewer_os_architecture' => 'setViewerOsArchitecture',
        'player_error_code' => 'setPlayerErrorCode',
        'buffering_rate' => 'setBufferingRate',
        'events' => 'setEvents',
        'player_name' => 'setPlayerName',
        'view_start' => 'setViewStart',
        'view_average_request_throughput' => 'setViewAverageRequestThroughput',
        'video_producer' => 'setVideoProducer',
        'error_type_id' => 'setErrorTypeId',
        'mux_viewer_id' => 'setMuxViewerId',
        'video_id' => 'setVideoId',
        'continent_code' => 'setContinentCode',
        'session_id' => 'setSessionId',
        'exit_before_video_start' => 'setExitBeforeVideoStart',
        'video_content_type' => 'setVideoContentType',
        'viewer_os_family' => 'setViewerOsFamily',
        'player_poster' => 'setPlayerPoster',
        'view_average_request_latency' => 'setViewAverageRequestLatency',
        'video_variant_id' => 'setVideoVariantId',
        'player_source_duration' => 'setPlayerSourceDuration',
        'player_source_url' => 'setPlayerSourceUrl',
        'mux_api_version' => 'setMuxApiVersion',
        'video_title' => 'setVideoTitle',
        'id' => 'setId',
        'short_time' => 'setShortTime',
        'rebuffer_percentage' => 'setRebufferPercentage',
        'time_to_first_frame' => 'setTimeToFirstFrame',
        'viewer_user_id' => 'setViewerUserId',
        'video_stream_type' => 'setVideoStreamType',
        'player_startup_time' => 'setPlayerStartupTime',
        'viewer_application_version' => 'setViewerApplicationVersion',
        'view_max_downscale_percentage' => 'setViewMaxDownscalePercentage',
        'view_max_upscale_percentage' => 'setViewMaxUpscalePercentage',
        'country_code' => 'setCountryCode',
        'used_fullscreen' => 'setUsedFullscreen',
        'isp' => 'setIsp',
        'property_id' => 'setPropertyId',
        'player_autoplay' => 'setPlayerAutoplay',
        'player_height' => 'setPlayerHeight',
        'asn' => 'setAsn',
        'asn_name' => 'setAsnName',
        'quality_score' => 'setQualityScore',
        'player_software_version' => 'setPlayerSoftwareVersion',
        'player_mux_plugin_name' => 'setPlayerMuxPluginName',
        'sub_property_id' => 'setSubPropertyId',
        'player_remote_played' => 'setPlayerRemotePlayed',
        'view_max_playhead_position' => 'setViewMaxPlayheadPosition',
        'view_playing_time' => 'setViewPlayingTime',
        'view_session_id' => 'setViewSessionId',
        'viewer_connection_type' => 'setViewerConnectionType',
        'viewer_device_model' => 'setViewerDeviceModel',
        'weighted_average_bitrate' => 'setWeightedAverageBitrate',
        'custom_1' => 'setCustom1',
        'custom_2' => 'setCustom2',
        'custom_3' => 'setCustom3',
        'custom_4' => 'setCustom4',
        'custom_5' => 'setCustom5',
        'custom_6' => 'setCustom6',
        'custom_7' => 'setCustom7',
        'custom_8' => 'setCustom8',
        'custom_9' => 'setCustom9',
        'custom_10' => 'setCustom10',
        'live_stream_latency' => 'setLiveStreamLatency',
        'asset_id' => 'setAssetId',
        'environment_id' => 'setEnvironmentId',
        'live_stream_id' => 'setLiveStreamId',
        'mux_embed' => 'setMuxEmbed',
        'playback_id' => 'setPlaybackId',
        'player_error_context' => 'setPlayerErrorContext',
        'view_drm_type' => 'setViewDrmType',
        'view_dropped_frame_count' => 'setViewDroppedFrameCount',
        'view_has_ad' => 'setViewHasAd',
        'video_startup_failure' => 'setVideoStartupFailure',
        'ad_attempt_count' => 'setAdAttemptCount',
        'ad_break_count' => 'setAdBreakCount',
        'ad_break_error_count' => 'setAdBreakErrorCount',
        'ad_break_error_percentage' => 'setAdBreakErrorPercentage',
        'ad_error_count' => 'setAdErrorCount',
        'ad_error_percentage' => 'setAdErrorPercentage',
        'ad_impression_count' => 'setAdImpressionCount',
        'ad_startup_error_count' => 'setAdStartupErrorCount',
        'ad_startup_error_percentage' => 'setAdStartupErrorPercentage',
        'ad_exit_before_start_count' => 'setAdExitBeforeStartCount',
        'ad_exit_before_start_percentage' => 'setAdExitBeforeStartPercentage',
        'long_resume' => 'setLongResume',
        'long_rebuffering' => 'setLongRebuffering',
        'playback_failure_error_type_id' => 'setPlaybackFailureErrorTypeId',
        'playback_business_exception_error_type_id' => 'setPlaybackBusinessExceptionErrorTypeId',
        'video_startup_business_exception_error_type_id' => 'setVideoStartupBusinessExceptionErrorTypeId',
        'playback_failure' => 'setPlaybackFailure',
        'ad_playback_failure_error_type_id' => 'setAdPlaybackFailureErrorTypeId',
        'view_content_startup_time' => 'setViewContentStartupTime',
        'ad_preroll_startup_time' => 'setAdPrerollStartupTime',
        'ad_watch_time' => 'setAdWatchTime',
        'view_content_watch_time' => 'setViewContentWatchTime'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'view_total_upscaling' => 'getViewTotalUpscaling',
        'preroll_ad_asset_hostname' => 'getPrerollAdAssetHostname',
        'player_source_domain' => 'getPlayerSourceDomain',
        'region' => 'getRegion',
        'viewer_user_agent' => 'getViewerUserAgent',
        'preroll_requested' => 'getPrerollRequested',
        'page_type' => 'getPageType',
        'startup_score' => 'getStartupScore',
        'view_seek_duration' => 'getViewSeekDuration',
        'country_name' => 'getCountryName',
        'player_source_height' => 'getPlayerSourceHeight',
        'longitude' => 'getLongitude',
        'buffering_count' => 'getBufferingCount',
        'video_duration' => 'getVideoDuration',
        'player_source_type' => 'getPlayerSourceType',
        'city' => 'getCity',
        'view_id' => 'getViewId',
        'platform_description' => 'getPlatformDescription',
        'video_startup_preroll_request_time' => 'getVideoStartupPrerollRequestTime',
        'viewer_device_name' => 'getViewerDeviceName',
        'video_series' => 'getVideoSeries',
        'viewer_application_name' => 'getViewerApplicationName',
        'updated_at' => 'getUpdatedAt',
        'view_total_content_playback_time' => 'getViewTotalContentPlaybackTime',
        'cdn' => 'getCdn',
        'player_instance_id' => 'getPlayerInstanceId',
        'video_language' => 'getVideoLanguage',
        'player_source_width' => 'getPlayerSourceWidth',
        'player_error_message' => 'getPlayerErrorMessage',
        'player_mux_plugin_version' => 'getPlayerMuxPluginVersion',
        'watched' => 'getWatched',
        'playback_score' => 'getPlaybackScore',
        'page_url' => 'getPageUrl',
        'metro' => 'getMetro',
        'view_max_request_latency' => 'getViewMaxRequestLatency',
        'requests_for_first_preroll' => 'getRequestsForFirstPreroll',
        'view_total_downscaling' => 'getViewTotalDownscaling',
        'latitude' => 'getLatitude',
        'player_source_host_name' => 'getPlayerSourceHostName',
        'inserted_at' => 'getInsertedAt',
        'view_end' => 'getViewEnd',
        'mux_embed_version' => 'getMuxEmbedVersion',
        'player_language' => 'getPlayerLanguage',
        'page_load_time' => 'getPageLoadTime',
        'viewer_device_category' => 'getViewerDeviceCategory',
        'video_startup_preroll_load_time' => 'getVideoStartupPrerollLoadTime',
        'player_version' => 'getPlayerVersion',
        'watch_time' => 'getWatchTime',
        'player_source_stream_type' => 'getPlayerSourceStreamType',
        'preroll_ad_tag_hostname' => 'getPrerollAdTagHostname',
        'viewer_device_manufacturer' => 'getViewerDeviceManufacturer',
        'rebuffering_score' => 'getRebufferingScore',
        'experiment_name' => 'getExperimentName',
        'viewer_os_version' => 'getViewerOsVersion',
        'player_preload' => 'getPlayerPreload',
        'buffering_duration' => 'getBufferingDuration',
        'player_view_count' => 'getPlayerViewCount',
        'player_software' => 'getPlayerSoftware',
        'player_load_time' => 'getPlayerLoadTime',
        'platform_summary' => 'getPlatformSummary',
        'video_encoding_variant' => 'getVideoEncodingVariant',
        'player_width' => 'getPlayerWidth',
        'view_seek_count' => 'getViewSeekCount',
        'viewer_experience_score' => 'getViewerExperienceScore',
        'view_error_id' => 'getViewErrorId',
        'video_variant_name' => 'getVideoVariantName',
        'preroll_played' => 'getPrerollPlayed',
        'viewer_application_engine' => 'getViewerApplicationEngine',
        'viewer_os_architecture' => 'getViewerOsArchitecture',
        'player_error_code' => 'getPlayerErrorCode',
        'buffering_rate' => 'getBufferingRate',
        'events' => 'getEvents',
        'player_name' => 'getPlayerName',
        'view_start' => 'getViewStart',
        'view_average_request_throughput' => 'getViewAverageRequestThroughput',
        'video_producer' => 'getVideoProducer',
        'error_type_id' => 'getErrorTypeId',
        'mux_viewer_id' => 'getMuxViewerId',
        'video_id' => 'getVideoId',
        'continent_code' => 'getContinentCode',
        'session_id' => 'getSessionId',
        'exit_before_video_start' => 'getExitBeforeVideoStart',
        'video_content_type' => 'getVideoContentType',
        'viewer_os_family' => 'getViewerOsFamily',
        'player_poster' => 'getPlayerPoster',
        'view_average_request_latency' => 'getViewAverageRequestLatency',
        'video_variant_id' => 'getVideoVariantId',
        'player_source_duration' => 'getPlayerSourceDuration',
        'player_source_url' => 'getPlayerSourceUrl',
        'mux_api_version' => 'getMuxApiVersion',
        'video_title' => 'getVideoTitle',
        'id' => 'getId',
        'short_time' => 'getShortTime',
        'rebuffer_percentage' => 'getRebufferPercentage',
        'time_to_first_frame' => 'getTimeToFirstFrame',
        'viewer_user_id' => 'getViewerUserId',
        'video_stream_type' => 'getVideoStreamType',
        'player_startup_time' => 'getPlayerStartupTime',
        'viewer_application_version' => 'getViewerApplicationVersion',
        'view_max_downscale_percentage' => 'getViewMaxDownscalePercentage',
        'view_max_upscale_percentage' => 'getViewMaxUpscalePercentage',
        'country_code' => 'getCountryCode',
        'used_fullscreen' => 'getUsedFullscreen',
        'isp' => 'getIsp',
        'property_id' => 'getPropertyId',
        'player_autoplay' => 'getPlayerAutoplay',
        'player_height' => 'getPlayerHeight',
        'asn' => 'getAsn',
        'asn_name' => 'getAsnName',
        'quality_score' => 'getQualityScore',
        'player_software_version' => 'getPlayerSoftwareVersion',
        'player_mux_plugin_name' => 'getPlayerMuxPluginName',
        'sub_property_id' => 'getSubPropertyId',
        'player_remote_played' => 'getPlayerRemotePlayed',
        'view_max_playhead_position' => 'getViewMaxPlayheadPosition',
        'view_playing_time' => 'getViewPlayingTime',
        'view_session_id' => 'getViewSessionId',
        'viewer_connection_type' => 'getViewerConnectionType',
        'viewer_device_model' => 'getViewerDeviceModel',
        'weighted_average_bitrate' => 'getWeightedAverageBitrate',
        'custom_1' => 'getCustom1',
        'custom_2' => 'getCustom2',
        'custom_3' => 'getCustom3',
        'custom_4' => 'getCustom4',
        'custom_5' => 'getCustom5',
        'custom_6' => 'getCustom6',
        'custom_7' => 'getCustom7',
        'custom_8' => 'getCustom8',
        'custom_9' => 'getCustom9',
        'custom_10' => 'getCustom10',
        'live_stream_latency' => 'getLiveStreamLatency',
        'asset_id' => 'getAssetId',
        'environment_id' => 'getEnvironmentId',
        'live_stream_id' => 'getLiveStreamId',
        'mux_embed' => 'getMuxEmbed',
        'playback_id' => 'getPlaybackId',
        'player_error_context' => 'getPlayerErrorContext',
        'view_drm_type' => 'getViewDrmType',
        'view_dropped_frame_count' => 'getViewDroppedFrameCount',
        'view_has_ad' => 'getViewHasAd',
        'video_startup_failure' => 'getVideoStartupFailure',
        'ad_attempt_count' => 'getAdAttemptCount',
        'ad_break_count' => 'getAdBreakCount',
        'ad_break_error_count' => 'getAdBreakErrorCount',
        'ad_break_error_percentage' => 'getAdBreakErrorPercentage',
        'ad_error_count' => 'getAdErrorCount',
        'ad_error_percentage' => 'getAdErrorPercentage',
        'ad_impression_count' => 'getAdImpressionCount',
        'ad_startup_error_count' => 'getAdStartupErrorCount',
        'ad_startup_error_percentage' => 'getAdStartupErrorPercentage',
        'ad_exit_before_start_count' => 'getAdExitBeforeStartCount',
        'ad_exit_before_start_percentage' => 'getAdExitBeforeStartPercentage',
        'long_resume' => 'getLongResume',
        'long_rebuffering' => 'getLongRebuffering',
        'playback_failure_error_type_id' => 'getPlaybackFailureErrorTypeId',
        'playback_business_exception_error_type_id' => 'getPlaybackBusinessExceptionErrorTypeId',
        'video_startup_business_exception_error_type_id' => 'getVideoStartupBusinessExceptionErrorTypeId',
        'playback_failure' => 'getPlaybackFailure',
        'ad_playback_failure_error_type_id' => 'getAdPlaybackFailureErrorTypeId',
        'view_content_startup_time' => 'getViewContentStartupTime',
        'ad_preroll_startup_time' => 'getAdPrerollStartupTime',
        'ad_watch_time' => 'getAdWatchTime',
        'view_content_watch_time' => 'getViewContentWatchTime'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        // MUX: enum hack (self::) due to OAS emitting problems.
        //      please re-integrate with mainline when possible.
        //      src: https://github.com/OpenAPITools/openapi-generator/issues/9038
        $this->setIfExists('view_total_upscaling', $data ?? [], null);
        $this->setIfExists('preroll_ad_asset_hostname', $data ?? [], null);
        $this->setIfExists('player_source_domain', $data ?? [], null);
        $this->setIfExists('region', $data ?? [], null);
        $this->setIfExists('viewer_user_agent', $data ?? [], null);
        $this->setIfExists('preroll_requested', $data ?? [], null);
        $this->setIfExists('page_type', $data ?? [], null);
        $this->setIfExists('startup_score', $data ?? [], null);
        $this->setIfExists('view_seek_duration', $data ?? [], null);
        $this->setIfExists('country_name', $data ?? [], null);
        $this->setIfExists('player_source_height', $data ?? [], null);
        $this->setIfExists('longitude', $data ?? [], null);
        $this->setIfExists('buffering_count', $data ?? [], null);
        $this->setIfExists('video_duration', $data ?? [], null);
        $this->setIfExists('player_source_type', $data ?? [], null);
        $this->setIfExists('city', $data ?? [], null);
        $this->setIfExists('view_id', $data ?? [], null);
        $this->setIfExists('platform_description', $data ?? [], null);
        $this->setIfExists('video_startup_preroll_request_time', $data ?? [], null);
        $this->setIfExists('viewer_device_name', $data ?? [], null);
        $this->setIfExists('video_series', $data ?? [], null);
        $this->setIfExists('viewer_application_name', $data ?? [], null);
        $this->setIfExists('updated_at', $data ?? [], null);
        $this->setIfExists('view_total_content_playback_time', $data ?? [], null);
        $this->setIfExists('cdn', $data ?? [], null);
        $this->setIfExists('player_instance_id', $data ?? [], null);
        $this->setIfExists('video_language', $data ?? [], null);
        $this->setIfExists('player_source_width', $data ?? [], null);
        $this->setIfExists('player_error_message', $data ?? [], null);
        $this->setIfExists('player_mux_plugin_version', $data ?? [], null);
        $this->setIfExists('watched', $data ?? [], null);
        $this->setIfExists('playback_score', $data ?? [], null);
        $this->setIfExists('page_url', $data ?? [], null);
        $this->setIfExists('metro', $data ?? [], null);
        $this->setIfExists('view_max_request_latency', $data ?? [], null);
        $this->setIfExists('requests_for_first_preroll', $data ?? [], null);
        $this->setIfExists('view_total_downscaling', $data ?? [], null);
        $this->setIfExists('latitude', $data ?? [], null);
        $this->setIfExists('player_source_host_name', $data ?? [], null);
        $this->setIfExists('inserted_at', $data ?? [], null);
        $this->setIfExists('view_end', $data ?? [], null);
        $this->setIfExists('mux_embed_version', $data ?? [], null);
        $this->setIfExists('player_language', $data ?? [], null);
        $this->setIfExists('page_load_time', $data ?? [], null);
        $this->setIfExists('viewer_device_category', $data ?? [], null);
        $this->setIfExists('video_startup_preroll_load_time', $data ?? [], null);
        $this->setIfExists('player_version', $data ?? [], null);
        $this->setIfExists('watch_time', $data ?? [], null);
        $this->setIfExists('player_source_stream_type', $data ?? [], null);
        $this->setIfExists('preroll_ad_tag_hostname', $data ?? [], null);
        $this->setIfExists('viewer_device_manufacturer', $data ?? [], null);
        $this->setIfExists('rebuffering_score', $data ?? [], null);
        $this->setIfExists('experiment_name', $data ?? [], null);
        $this->setIfExists('viewer_os_version', $data ?? [], null);
        $this->setIfExists('player_preload', $data ?? [], null);
        $this->setIfExists('buffering_duration', $data ?? [], null);
        $this->setIfExists('player_view_count', $data ?? [], null);
        $this->setIfExists('player_software', $data ?? [], null);
        $this->setIfExists('player_load_time', $data ?? [], null);
        $this->setIfExists('platform_summary', $data ?? [], null);
        $this->setIfExists('video_encoding_variant', $data ?? [], null);
        $this->setIfExists('player_width', $data ?? [], null);
        $this->setIfExists('view_seek_count', $data ?? [], null);
        $this->setIfExists('viewer_experience_score', $data ?? [], null);
        $this->setIfExists('view_error_id', $data ?? [], null);
        $this->setIfExists('video_variant_name', $data ?? [], null);
        $this->setIfExists('preroll_played', $data ?? [], null);
        $this->setIfExists('viewer_application_engine', $data ?? [], null);
        $this->setIfExists('viewer_os_architecture', $data ?? [], null);
        $this->setIfExists('player_error_code', $data ?? [], null);
        $this->setIfExists('buffering_rate', $data ?? [], null);
        $this->setIfExists('events', $data ?? [], null);
        $this->setIfExists('player_name', $data ?? [], null);
        $this->setIfExists('view_start', $data ?? [], null);
        $this->setIfExists('view_average_request_throughput', $data ?? [], null);
        $this->setIfExists('video_producer', $data ?? [], null);
        $this->setIfExists('error_type_id', $data ?? [], null);
        $this->setIfExists('mux_viewer_id', $data ?? [], null);
        $this->setIfExists('video_id', $data ?? [], null);
        $this->setIfExists('continent_code', $data ?? [], null);
        $this->setIfExists('session_id', $data ?? [], null);
        $this->setIfExists('exit_before_video_start', $data ?? [], null);
        $this->setIfExists('video_content_type', $data ?? [], null);
        $this->setIfExists('viewer_os_family', $data ?? [], null);
        $this->setIfExists('player_poster', $data ?? [], null);
        $this->setIfExists('view_average_request_latency', $data ?? [], null);
        $this->setIfExists('video_variant_id', $data ?? [], null);
        $this->setIfExists('player_source_duration', $data ?? [], null);
        $this->setIfExists('player_source_url', $data ?? [], null);
        $this->setIfExists('mux_api_version', $data ?? [], null);
        $this->setIfExists('video_title', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('short_time', $data ?? [], null);
        $this->setIfExists('rebuffer_percentage', $data ?? [], null);
        $this->setIfExists('time_to_first_frame', $data ?? [], null);
        $this->setIfExists('viewer_user_id', $data ?? [], null);
        $this->setIfExists('video_stream_type', $data ?? [], null);
        $this->setIfExists('player_startup_time', $data ?? [], null);
        $this->setIfExists('viewer_application_version', $data ?? [], null);
        $this->setIfExists('view_max_downscale_percentage', $data ?? [], null);
        $this->setIfExists('view_max_upscale_percentage', $data ?? [], null);
        $this->setIfExists('country_code', $data ?? [], null);
        $this->setIfExists('used_fullscreen', $data ?? [], null);
        $this->setIfExists('isp', $data ?? [], null);
        $this->setIfExists('property_id', $data ?? [], null);
        $this->setIfExists('player_autoplay', $data ?? [], null);
        $this->setIfExists('player_height', $data ?? [], null);
        $this->setIfExists('asn', $data ?? [], null);
        $this->setIfExists('asn_name', $data ?? [], null);
        $this->setIfExists('quality_score', $data ?? [], null);
        $this->setIfExists('player_software_version', $data ?? [], null);
        $this->setIfExists('player_mux_plugin_name', $data ?? [], null);
        $this->setIfExists('sub_property_id', $data ?? [], null);
        $this->setIfExists('player_remote_played', $data ?? [], null);
        $this->setIfExists('view_max_playhead_position', $data ?? [], null);
        $this->setIfExists('view_playing_time', $data ?? [], null);
        $this->setIfExists('view_session_id', $data ?? [], null);
        $this->setIfExists('viewer_connection_type', $data ?? [], null);
        $this->setIfExists('viewer_device_model', $data ?? [], null);
        $this->setIfExists('weighted_average_bitrate', $data ?? [], null);
        $this->setIfExists('custom_1', $data ?? [], null);
        $this->setIfExists('custom_2', $data ?? [], null);
        $this->setIfExists('custom_3', $data ?? [], null);
        $this->setIfExists('custom_4', $data ?? [], null);
        $this->setIfExists('custom_5', $data ?? [], null);
        $this->setIfExists('custom_6', $data ?? [], null);
        $this->setIfExists('custom_7', $data ?? [], null);
        $this->setIfExists('custom_8', $data ?? [], null);
        $this->setIfExists('custom_9', $data ?? [], null);
        $this->setIfExists('custom_10', $data ?? [], null);
        $this->setIfExists('live_stream_latency', $data ?? [], null);
        $this->setIfExists('asset_id', $data ?? [], null);
        $this->setIfExists('environment_id', $data ?? [], null);
        $this->setIfExists('live_stream_id', $data ?? [], null);
        $this->setIfExists('mux_embed', $data ?? [], null);
        $this->setIfExists('playback_id', $data ?? [], null);
        $this->setIfExists('player_error_context', $data ?? [], null);
        $this->setIfExists('view_drm_type', $data ?? [], null);
        $this->setIfExists('view_dropped_frame_count', $data ?? [], null);
        $this->setIfExists('view_has_ad', $data ?? [], null);
        $this->setIfExists('video_startup_failure', $data ?? [], null);
        $this->setIfExists('ad_attempt_count', $data ?? [], null);
        $this->setIfExists('ad_break_count', $data ?? [], null);
        $this->setIfExists('ad_break_error_count', $data ?? [], null);
        $this->setIfExists('ad_break_error_percentage', $data ?? [], null);
        $this->setIfExists('ad_error_count', $data ?? [], null);
        $this->setIfExists('ad_error_percentage', $data ?? [], null);
        $this->setIfExists('ad_impression_count', $data ?? [], null);
        $this->setIfExists('ad_startup_error_count', $data ?? [], null);
        $this->setIfExists('ad_startup_error_percentage', $data ?? [], null);
        $this->setIfExists('ad_exit_before_start_count', $data ?? [], null);
        $this->setIfExists('ad_exit_before_start_percentage', $data ?? [], null);
        $this->setIfExists('long_resume', $data ?? [], null);
        $this->setIfExists('long_rebuffering', $data ?? [], null);
        $this->setIfExists('playback_failure_error_type_id', $data ?? [], null);
        $this->setIfExists('playback_business_exception_error_type_id', $data ?? [], null);
        $this->setIfExists('video_startup_business_exception_error_type_id', $data ?? [], null);
        $this->setIfExists('playback_failure', $data ?? [], null);
        $this->setIfExists('ad_playback_failure_error_type_id', $data ?? [], null);
        $this->setIfExists('view_content_startup_time', $data ?? [], null);
        $this->setIfExists('ad_preroll_startup_time', $data ?? [], null);
        $this->setIfExists('ad_watch_time', $data ?? [], null);
        $this->setIfExists('view_content_watch_time', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets view_total_upscaling
     *
     * @return string|null
     */
    public function getViewTotalUpscaling()
    {
        return $this->container['view_total_upscaling'];
    }

    /**
     * Sets view_total_upscaling
     *
     * @param string|null $view_total_upscaling view_total_upscaling
     *
     * @return self
     */
    public function setViewTotalUpscaling($view_total_upscaling)
    {

        if (is_null($view_total_upscaling)) {
            array_push($this->openAPINullablesSetToNull, 'view_total_upscaling');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_total_upscaling', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_total_upscaling'] = $view_total_upscaling;

        return $this;
    }

    /**
     * Gets preroll_ad_asset_hostname
     *
     * @return string|null
     */
    public function getPrerollAdAssetHostname()
    {
        return $this->container['preroll_ad_asset_hostname'];
    }

    /**
     * Sets preroll_ad_asset_hostname
     *
     * @param string|null $preroll_ad_asset_hostname preroll_ad_asset_hostname
     *
     * @return self
     */
    public function setPrerollAdAssetHostname($preroll_ad_asset_hostname)
    {

        if (is_null($preroll_ad_asset_hostname)) {
            array_push($this->openAPINullablesSetToNull, 'preroll_ad_asset_hostname');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('preroll_ad_asset_hostname', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['preroll_ad_asset_hostname'] = $preroll_ad_asset_hostname;

        return $this;
    }

    /**
     * Gets player_source_domain
     *
     * @return string|null
     */
    public function getPlayerSourceDomain()
    {
        return $this->container['player_source_domain'];
    }

    /**
     * Sets player_source_domain
     *
     * @param string|null $player_source_domain player_source_domain
     *
     * @return self
     */
    public function setPlayerSourceDomain($player_source_domain)
    {

        if (is_null($player_source_domain)) {
            array_push($this->openAPINullablesSetToNull, 'player_source_domain');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_source_domain', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_source_domain'] = $player_source_domain;

        return $this;
    }

    /**
     * Gets region
     *
     * @return string|null
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region
     *
     * @param string|null $region region
     *
     * @return self
     */
    public function setRegion($region)
    {

        if (is_null($region)) {
            array_push($this->openAPINullablesSetToNull, 'region');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('region', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets viewer_user_agent
     *
     * @return string|null
     */
    public function getViewerUserAgent()
    {
        return $this->container['viewer_user_agent'];
    }

    /**
     * Sets viewer_user_agent
     *
     * @param string|null $viewer_user_agent viewer_user_agent
     *
     * @return self
     */
    public function setViewerUserAgent($viewer_user_agent)
    {

        if (is_null($viewer_user_agent)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_user_agent');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_user_agent', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_user_agent'] = $viewer_user_agent;

        return $this;
    }

    /**
     * Gets preroll_requested
     *
     * @return bool|null
     */
    public function getPrerollRequested()
    {
        return $this->container['preroll_requested'];
    }

    /**
     * Sets preroll_requested
     *
     * @param bool|null $preroll_requested preroll_requested
     *
     * @return self
     */
    public function setPrerollRequested($preroll_requested)
    {

        if (is_null($preroll_requested)) {
            array_push($this->openAPINullablesSetToNull, 'preroll_requested');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('preroll_requested', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['preroll_requested'] = $preroll_requested;

        return $this;
    }

    /**
     * Gets page_type
     *
     * @return string|null
     */
    public function getPageType()
    {
        return $this->container['page_type'];
    }

    /**
     * Sets page_type
     *
     * @param string|null $page_type page_type
     *
     * @return self
     */
    public function setPageType($page_type)
    {

        if (is_null($page_type)) {
            array_push($this->openAPINullablesSetToNull, 'page_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('page_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['page_type'] = $page_type;

        return $this;
    }

    /**
     * Gets startup_score
     *
     * @return string|null
     */
    public function getStartupScore()
    {
        return $this->container['startup_score'];
    }

    /**
     * Sets startup_score
     *
     * @param string|null $startup_score startup_score
     *
     * @return self
     */
    public function setStartupScore($startup_score)
    {

        if (is_null($startup_score)) {
            array_push($this->openAPINullablesSetToNull, 'startup_score');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('startup_score', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['startup_score'] = $startup_score;

        return $this;
    }

    /**
     * Gets view_seek_duration
     *
     * @return int|null
     */
    public function getViewSeekDuration()
    {
        return $this->container['view_seek_duration'];
    }

    /**
     * Sets view_seek_duration
     *
     * @param int|null $view_seek_duration view_seek_duration
     *
     * @return self
     */
    public function setViewSeekDuration($view_seek_duration)
    {

        if (is_null($view_seek_duration)) {
            array_push($this->openAPINullablesSetToNull, 'view_seek_duration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_seek_duration', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_seek_duration'] = $view_seek_duration;

        return $this;
    }

    /**
     * Gets country_name
     *
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->container['country_name'];
    }

    /**
     * Sets country_name
     *
     * @param string|null $country_name country_name
     *
     * @return self
     */
    public function setCountryName($country_name)
    {

        if (is_null($country_name)) {
            array_push($this->openAPINullablesSetToNull, 'country_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('country_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['country_name'] = $country_name;

        return $this;
    }

    /**
     * Gets player_source_height
     *
     * @return int|null
     */
    public function getPlayerSourceHeight()
    {
        return $this->container['player_source_height'];
    }

    /**
     * Sets player_source_height
     *
     * @param int|null $player_source_height player_source_height
     *
     * @return self
     */
    public function setPlayerSourceHeight($player_source_height)
    {

        if (is_null($player_source_height)) {
            array_push($this->openAPINullablesSetToNull, 'player_source_height');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_source_height', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_source_height'] = $player_source_height;

        return $this;
    }

    /**
     * Gets longitude
     *
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->container['longitude'];
    }

    /**
     * Sets longitude
     *
     * @param string|null $longitude longitude
     *
     * @return self
     */
    public function setLongitude($longitude)
    {

        if (is_null($longitude)) {
            array_push($this->openAPINullablesSetToNull, 'longitude');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('longitude', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['longitude'] = $longitude;

        return $this;
    }

    /**
     * Gets buffering_count
     *
     * @return int|null
     */
    public function getBufferingCount()
    {
        return $this->container['buffering_count'];
    }

    /**
     * Sets buffering_count
     *
     * @param int|null $buffering_count buffering_count
     *
     * @return self
     */
    public function setBufferingCount($buffering_count)
    {

        if (is_null($buffering_count)) {
            array_push($this->openAPINullablesSetToNull, 'buffering_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('buffering_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['buffering_count'] = $buffering_count;

        return $this;
    }

    /**
     * Gets video_duration
     *
     * @return int|null
     */
    public function getVideoDuration()
    {
        return $this->container['video_duration'];
    }

    /**
     * Sets video_duration
     *
     * @param int|null $video_duration video_duration
     *
     * @return self
     */
    public function setVideoDuration($video_duration)
    {

        if (is_null($video_duration)) {
            array_push($this->openAPINullablesSetToNull, 'video_duration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_duration', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_duration'] = $video_duration;

        return $this;
    }

    /**
     * Gets player_source_type
     *
     * @return string|null
     */
    public function getPlayerSourceType()
    {
        return $this->container['player_source_type'];
    }

    /**
     * Sets player_source_type
     *
     * @param string|null $player_source_type player_source_type
     *
     * @return self
     */
    public function setPlayerSourceType($player_source_type)
    {

        if (is_null($player_source_type)) {
            array_push($this->openAPINullablesSetToNull, 'player_source_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_source_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_source_type'] = $player_source_type;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city city
     *
     * @return self
     */
    public function setCity($city)
    {

        if (is_null($city)) {
            array_push($this->openAPINullablesSetToNull, 'city');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('city', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets view_id
     *
     * @return string|null
     */
    public function getViewId()
    {
        return $this->container['view_id'];
    }

    /**
     * Sets view_id
     *
     * @param string|null $view_id view_id
     *
     * @return self
     */
    public function setViewId($view_id)
    {

        if (is_null($view_id)) {
            throw new \InvalidArgumentException('non-nullable view_id cannot be null');
        }

        $this->container['view_id'] = $view_id;

        return $this;
    }

    /**
     * Gets platform_description
     *
     * @return string|null
     */
    public function getPlatformDescription()
    {
        return $this->container['platform_description'];
    }

    /**
     * Sets platform_description
     *
     * @param string|null $platform_description platform_description
     *
     * @return self
     */
    public function setPlatformDescription($platform_description)
    {

        if (is_null($platform_description)) {
            array_push($this->openAPINullablesSetToNull, 'platform_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('platform_description', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['platform_description'] = $platform_description;

        return $this;
    }

    /**
     * Gets video_startup_preroll_request_time
     *
     * @return int|null
     */
    public function getVideoStartupPrerollRequestTime()
    {
        return $this->container['video_startup_preroll_request_time'];
    }

    /**
     * Sets video_startup_preroll_request_time
     *
     * @param int|null $video_startup_preroll_request_time video_startup_preroll_request_time
     *
     * @return self
     */
    public function setVideoStartupPrerollRequestTime($video_startup_preroll_request_time)
    {

        if (is_null($video_startup_preroll_request_time)) {
            array_push($this->openAPINullablesSetToNull, 'video_startup_preroll_request_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_startup_preroll_request_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_startup_preroll_request_time'] = $video_startup_preroll_request_time;

        return $this;
    }

    /**
     * Gets viewer_device_name
     *
     * @return string|null
     */
    public function getViewerDeviceName()
    {
        return $this->container['viewer_device_name'];
    }

    /**
     * Sets viewer_device_name
     *
     * @param string|null $viewer_device_name viewer_device_name
     *
     * @return self
     */
    public function setViewerDeviceName($viewer_device_name)
    {

        if (is_null($viewer_device_name)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_device_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_device_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_device_name'] = $viewer_device_name;

        return $this;
    }

    /**
     * Gets video_series
     *
     * @return string|null
     */
    public function getVideoSeries()
    {
        return $this->container['video_series'];
    }

    /**
     * Sets video_series
     *
     * @param string|null $video_series video_series
     *
     * @return self
     */
    public function setVideoSeries($video_series)
    {

        if (is_null($video_series)) {
            array_push($this->openAPINullablesSetToNull, 'video_series');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_series', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_series'] = $video_series;

        return $this;
    }

    /**
     * Gets viewer_application_name
     *
     * @return string|null
     */
    public function getViewerApplicationName()
    {
        return $this->container['viewer_application_name'];
    }

    /**
     * Sets viewer_application_name
     *
     * @param string|null $viewer_application_name viewer_application_name
     *
     * @return self
     */
    public function setViewerApplicationName($viewer_application_name)
    {

        if (is_null($viewer_application_name)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_application_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_application_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_application_name'] = $viewer_application_name;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at updated_at
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {

        if (is_null($updated_at)) {
            throw new \InvalidArgumentException('non-nullable updated_at cannot be null');
        }

        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets view_total_content_playback_time
     *
     * @return int|null
     */
    public function getViewTotalContentPlaybackTime()
    {
        return $this->container['view_total_content_playback_time'];
    }

    /**
     * Sets view_total_content_playback_time
     *
     * @param int|null $view_total_content_playback_time view_total_content_playback_time
     *
     * @return self
     */
    public function setViewTotalContentPlaybackTime($view_total_content_playback_time)
    {

        if (is_null($view_total_content_playback_time)) {
            array_push($this->openAPINullablesSetToNull, 'view_total_content_playback_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_total_content_playback_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_total_content_playback_time'] = $view_total_content_playback_time;

        return $this;
    }

    /**
     * Gets cdn
     *
     * @return string|null
     */
    public function getCdn()
    {
        return $this->container['cdn'];
    }

    /**
     * Sets cdn
     *
     * @param string|null $cdn cdn
     *
     * @return self
     */
    public function setCdn($cdn)
    {

        if (is_null($cdn)) {
            array_push($this->openAPINullablesSetToNull, 'cdn');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cdn', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['cdn'] = $cdn;

        return $this;
    }

    /**
     * Gets player_instance_id
     *
     * @return string|null
     */
    public function getPlayerInstanceId()
    {
        return $this->container['player_instance_id'];
    }

    /**
     * Sets player_instance_id
     *
     * @param string|null $player_instance_id player_instance_id
     *
     * @return self
     */
    public function setPlayerInstanceId($player_instance_id)
    {

        if (is_null($player_instance_id)) {
            array_push($this->openAPINullablesSetToNull, 'player_instance_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_instance_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_instance_id'] = $player_instance_id;

        return $this;
    }

    /**
     * Gets video_language
     *
     * @return string|null
     */
    public function getVideoLanguage()
    {
        return $this->container['video_language'];
    }

    /**
     * Sets video_language
     *
     * @param string|null $video_language video_language
     *
     * @return self
     */
    public function setVideoLanguage($video_language)
    {

        if (is_null($video_language)) {
            array_push($this->openAPINullablesSetToNull, 'video_language');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_language', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_language'] = $video_language;

        return $this;
    }

    /**
     * Gets player_source_width
     *
     * @return int|null
     */
    public function getPlayerSourceWidth()
    {
        return $this->container['player_source_width'];
    }

    /**
     * Sets player_source_width
     *
     * @param int|null $player_source_width player_source_width
     *
     * @return self
     */
    public function setPlayerSourceWidth($player_source_width)
    {

        if (is_null($player_source_width)) {
            array_push($this->openAPINullablesSetToNull, 'player_source_width');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_source_width', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_source_width'] = $player_source_width;

        return $this;
    }

    /**
     * Gets player_error_message
     *
     * @return string|null
     */
    public function getPlayerErrorMessage()
    {
        return $this->container['player_error_message'];
    }

    /**
     * Sets player_error_message
     *
     * @param string|null $player_error_message player_error_message
     *
     * @return self
     */
    public function setPlayerErrorMessage($player_error_message)
    {

        if (is_null($player_error_message)) {
            array_push($this->openAPINullablesSetToNull, 'player_error_message');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_error_message', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_error_message'] = $player_error_message;

        return $this;
    }

    /**
     * Gets player_mux_plugin_version
     *
     * @return string|null
     */
    public function getPlayerMuxPluginVersion()
    {
        return $this->container['player_mux_plugin_version'];
    }

    /**
     * Sets player_mux_plugin_version
     *
     * @param string|null $player_mux_plugin_version player_mux_plugin_version
     *
     * @return self
     */
    public function setPlayerMuxPluginVersion($player_mux_plugin_version)
    {

        if (is_null($player_mux_plugin_version)) {
            array_push($this->openAPINullablesSetToNull, 'player_mux_plugin_version');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_mux_plugin_version', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_mux_plugin_version'] = $player_mux_plugin_version;

        return $this;
    }

    /**
     * Gets watched
     *
     * @return bool|null
     */
    public function getWatched()
    {
        return $this->container['watched'];
    }

    /**
     * Sets watched
     *
     * @param bool|null $watched watched
     *
     * @return self
     */
    public function setWatched($watched)
    {

        if (is_null($watched)) {
            throw new \InvalidArgumentException('non-nullable watched cannot be null');
        }

        $this->container['watched'] = $watched;

        return $this;
    }

    /**
     * Gets playback_score
     *
     * @return string|null
     */
    public function getPlaybackScore()
    {
        return $this->container['playback_score'];
    }

    /**
     * Sets playback_score
     *
     * @param string|null $playback_score playback_score
     *
     * @return self
     */
    public function setPlaybackScore($playback_score)
    {

        if (is_null($playback_score)) {
            array_push($this->openAPINullablesSetToNull, 'playback_score');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('playback_score', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['playback_score'] = $playback_score;

        return $this;
    }

    /**
     * Gets page_url
     *
     * @return string|null
     */
    public function getPageUrl()
    {
        return $this->container['page_url'];
    }

    /**
     * Sets page_url
     *
     * @param string|null $page_url page_url
     *
     * @return self
     */
    public function setPageUrl($page_url)
    {

        if (is_null($page_url)) {
            array_push($this->openAPINullablesSetToNull, 'page_url');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('page_url', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['page_url'] = $page_url;

        return $this;
    }

    /**
     * Gets metro
     *
     * @return string|null
     */
    public function getMetro()
    {
        return $this->container['metro'];
    }

    /**
     * Sets metro
     *
     * @param string|null $metro metro
     *
     * @return self
     */
    public function setMetro($metro)
    {

        if (is_null($metro)) {
            array_push($this->openAPINullablesSetToNull, 'metro');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('metro', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['metro'] = $metro;

        return $this;
    }

    /**
     * Gets view_max_request_latency
     *
     * @return int|null
     */
    public function getViewMaxRequestLatency()
    {
        return $this->container['view_max_request_latency'];
    }

    /**
     * Sets view_max_request_latency
     *
     * @param int|null $view_max_request_latency view_max_request_latency
     *
     * @return self
     */
    public function setViewMaxRequestLatency($view_max_request_latency)
    {

        if (is_null($view_max_request_latency)) {
            array_push($this->openAPINullablesSetToNull, 'view_max_request_latency');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_max_request_latency', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_max_request_latency'] = $view_max_request_latency;

        return $this;
    }

    /**
     * Gets requests_for_first_preroll
     *
     * @return int|null
     */
    public function getRequestsForFirstPreroll()
    {
        return $this->container['requests_for_first_preroll'];
    }

    /**
     * Sets requests_for_first_preroll
     *
     * @param int|null $requests_for_first_preroll requests_for_first_preroll
     *
     * @return self
     */
    public function setRequestsForFirstPreroll($requests_for_first_preroll)
    {

        if (is_null($requests_for_first_preroll)) {
            array_push($this->openAPINullablesSetToNull, 'requests_for_first_preroll');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requests_for_first_preroll', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['requests_for_first_preroll'] = $requests_for_first_preroll;

        return $this;
    }

    /**
     * Gets view_total_downscaling
     *
     * @return string|null
     */
    public function getViewTotalDownscaling()
    {
        return $this->container['view_total_downscaling'];
    }

    /**
     * Sets view_total_downscaling
     *
     * @param string|null $view_total_downscaling view_total_downscaling
     *
     * @return self
     */
    public function setViewTotalDownscaling($view_total_downscaling)
    {

        if (is_null($view_total_downscaling)) {
            array_push($this->openAPINullablesSetToNull, 'view_total_downscaling');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_total_downscaling', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_total_downscaling'] = $view_total_downscaling;

        return $this;
    }

    /**
     * Gets latitude
     *
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->container['latitude'];
    }

    /**
     * Sets latitude
     *
     * @param string|null $latitude latitude
     *
     * @return self
     */
    public function setLatitude($latitude)
    {

        if (is_null($latitude)) {
            array_push($this->openAPINullablesSetToNull, 'latitude');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('latitude', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['latitude'] = $latitude;

        return $this;
    }

    /**
     * Gets player_source_host_name
     *
     * @return string|null
     */
    public function getPlayerSourceHostName()
    {
        return $this->container['player_source_host_name'];
    }

    /**
     * Sets player_source_host_name
     *
     * @param string|null $player_source_host_name player_source_host_name
     *
     * @return self
     */
    public function setPlayerSourceHostName($player_source_host_name)
    {

        if (is_null($player_source_host_name)) {
            array_push($this->openAPINullablesSetToNull, 'player_source_host_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_source_host_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_source_host_name'] = $player_source_host_name;

        return $this;
    }

    /**
     * Gets inserted_at
     *
     * @return string|null
     */
    public function getInsertedAt()
    {
        return $this->container['inserted_at'];
    }

    /**
     * Sets inserted_at
     *
     * @param string|null $inserted_at inserted_at
     *
     * @return self
     */
    public function setInsertedAt($inserted_at)
    {

        if (is_null($inserted_at)) {
            throw new \InvalidArgumentException('non-nullable inserted_at cannot be null');
        }

        $this->container['inserted_at'] = $inserted_at;

        return $this;
    }

    /**
     * Gets view_end
     *
     * @return string|null
     */
    public function getViewEnd()
    {
        return $this->container['view_end'];
    }

    /**
     * Sets view_end
     *
     * @param string|null $view_end view_end
     *
     * @return self
     */
    public function setViewEnd($view_end)
    {

        if (is_null($view_end)) {
            throw new \InvalidArgumentException('non-nullable view_end cannot be null');
        }

        $this->container['view_end'] = $view_end;

        return $this;
    }

    /**
     * Gets mux_embed_version
     *
     * @return string|null
     */
    public function getMuxEmbedVersion()
    {
        return $this->container['mux_embed_version'];
    }

    /**
     * Sets mux_embed_version
     *
     * @param string|null $mux_embed_version mux_embed_version
     *
     * @return self
     */
    public function setMuxEmbedVersion($mux_embed_version)
    {

        if (is_null($mux_embed_version)) {
            array_push($this->openAPINullablesSetToNull, 'mux_embed_version');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('mux_embed_version', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['mux_embed_version'] = $mux_embed_version;

        return $this;
    }

    /**
     * Gets player_language
     *
     * @return string|null
     */
    public function getPlayerLanguage()
    {
        return $this->container['player_language'];
    }

    /**
     * Sets player_language
     *
     * @param string|null $player_language player_language
     *
     * @return self
     */
    public function setPlayerLanguage($player_language)
    {

        if (is_null($player_language)) {
            array_push($this->openAPINullablesSetToNull, 'player_language');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_language', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_language'] = $player_language;

        return $this;
    }

    /**
     * Gets page_load_time
     *
     * @return int|null
     */
    public function getPageLoadTime()
    {
        return $this->container['page_load_time'];
    }

    /**
     * Sets page_load_time
     *
     * @param int|null $page_load_time page_load_time
     *
     * @return self
     */
    public function setPageLoadTime($page_load_time)
    {

        if (is_null($page_load_time)) {
            array_push($this->openAPINullablesSetToNull, 'page_load_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('page_load_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['page_load_time'] = $page_load_time;

        return $this;
    }

    /**
     * Gets viewer_device_category
     *
     * @return string|null
     */
    public function getViewerDeviceCategory()
    {
        return $this->container['viewer_device_category'];
    }

    /**
     * Sets viewer_device_category
     *
     * @param string|null $viewer_device_category viewer_device_category
     *
     * @return self
     */
    public function setViewerDeviceCategory($viewer_device_category)
    {

        if (is_null($viewer_device_category)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_device_category');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_device_category', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_device_category'] = $viewer_device_category;

        return $this;
    }

    /**
     * Gets video_startup_preroll_load_time
     *
     * @return int|null
     */
    public function getVideoStartupPrerollLoadTime()
    {
        return $this->container['video_startup_preroll_load_time'];
    }

    /**
     * Sets video_startup_preroll_load_time
     *
     * @param int|null $video_startup_preroll_load_time video_startup_preroll_load_time
     *
     * @return self
     */
    public function setVideoStartupPrerollLoadTime($video_startup_preroll_load_time)
    {

        if (is_null($video_startup_preroll_load_time)) {
            array_push($this->openAPINullablesSetToNull, 'video_startup_preroll_load_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_startup_preroll_load_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_startup_preroll_load_time'] = $video_startup_preroll_load_time;

        return $this;
    }

    /**
     * Gets player_version
     *
     * @return string|null
     */
    public function getPlayerVersion()
    {
        return $this->container['player_version'];
    }

    /**
     * Sets player_version
     *
     * @param string|null $player_version player_version
     *
     * @return self
     */
    public function setPlayerVersion($player_version)
    {

        if (is_null($player_version)) {
            array_push($this->openAPINullablesSetToNull, 'player_version');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_version', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_version'] = $player_version;

        return $this;
    }

    /**
     * Gets watch_time
     *
     * @return int|null
     */
    public function getWatchTime()
    {
        return $this->container['watch_time'];
    }

    /**
     * Sets watch_time
     *
     * @param int|null $watch_time watch_time
     *
     * @return self
     */
    public function setWatchTime($watch_time)
    {

        if (is_null($watch_time)) {
            array_push($this->openAPINullablesSetToNull, 'watch_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('watch_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['watch_time'] = $watch_time;

        return $this;
    }

    /**
     * Gets player_source_stream_type
     *
     * @return string|null
     */
    public function getPlayerSourceStreamType()
    {
        return $this->container['player_source_stream_type'];
    }

    /**
     * Sets player_source_stream_type
     *
     * @param string|null $player_source_stream_type player_source_stream_type
     *
     * @return self
     */
    public function setPlayerSourceStreamType($player_source_stream_type)
    {

        if (is_null($player_source_stream_type)) {
            array_push($this->openAPINullablesSetToNull, 'player_source_stream_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_source_stream_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_source_stream_type'] = $player_source_stream_type;

        return $this;
    }

    /**
     * Gets preroll_ad_tag_hostname
     *
     * @return string|null
     */
    public function getPrerollAdTagHostname()
    {
        return $this->container['preroll_ad_tag_hostname'];
    }

    /**
     * Sets preroll_ad_tag_hostname
     *
     * @param string|null $preroll_ad_tag_hostname preroll_ad_tag_hostname
     *
     * @return self
     */
    public function setPrerollAdTagHostname($preroll_ad_tag_hostname)
    {

        if (is_null($preroll_ad_tag_hostname)) {
            array_push($this->openAPINullablesSetToNull, 'preroll_ad_tag_hostname');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('preroll_ad_tag_hostname', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['preroll_ad_tag_hostname'] = $preroll_ad_tag_hostname;

        return $this;
    }

    /**
     * Gets viewer_device_manufacturer
     *
     * @return string|null
     */
    public function getViewerDeviceManufacturer()
    {
        return $this->container['viewer_device_manufacturer'];
    }

    /**
     * Sets viewer_device_manufacturer
     *
     * @param string|null $viewer_device_manufacturer viewer_device_manufacturer
     *
     * @return self
     */
    public function setViewerDeviceManufacturer($viewer_device_manufacturer)
    {

        if (is_null($viewer_device_manufacturer)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_device_manufacturer');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_device_manufacturer', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_device_manufacturer'] = $viewer_device_manufacturer;

        return $this;
    }

    /**
     * Gets rebuffering_score
     *
     * @return string|null
     */
    public function getRebufferingScore()
    {
        return $this->container['rebuffering_score'];
    }

    /**
     * Sets rebuffering_score
     *
     * @param string|null $rebuffering_score rebuffering_score
     *
     * @return self
     */
    public function setRebufferingScore($rebuffering_score)
    {

        if (is_null($rebuffering_score)) {
            array_push($this->openAPINullablesSetToNull, 'rebuffering_score');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rebuffering_score', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['rebuffering_score'] = $rebuffering_score;

        return $this;
    }

    /**
     * Gets experiment_name
     *
     * @return string|null
     */
    public function getExperimentName()
    {
        return $this->container['experiment_name'];
    }

    /**
     * Sets experiment_name
     *
     * @param string|null $experiment_name experiment_name
     *
     * @return self
     */
    public function setExperimentName($experiment_name)
    {

        if (is_null($experiment_name)) {
            array_push($this->openAPINullablesSetToNull, 'experiment_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('experiment_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['experiment_name'] = $experiment_name;

        return $this;
    }

    /**
     * Gets viewer_os_version
     *
     * @return string|null
     */
    public function getViewerOsVersion()
    {
        return $this->container['viewer_os_version'];
    }

    /**
     * Sets viewer_os_version
     *
     * @param string|null $viewer_os_version viewer_os_version
     *
     * @return self
     */
    public function setViewerOsVersion($viewer_os_version)
    {

        if (is_null($viewer_os_version)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_os_version');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_os_version', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_os_version'] = $viewer_os_version;

        return $this;
    }

    /**
     * Gets player_preload
     *
     * @return bool|null
     */
    public function getPlayerPreload()
    {
        return $this->container['player_preload'];
    }

    /**
     * Sets player_preload
     *
     * @param bool|null $player_preload player_preload
     *
     * @return self
     */
    public function setPlayerPreload($player_preload)
    {

        if (is_null($player_preload)) {
            throw new \InvalidArgumentException('non-nullable player_preload cannot be null');
        }

        $this->container['player_preload'] = $player_preload;

        return $this;
    }

    /**
     * Gets buffering_duration
     *
     * @return int|null
     */
    public function getBufferingDuration()
    {
        return $this->container['buffering_duration'];
    }

    /**
     * Sets buffering_duration
     *
     * @param int|null $buffering_duration buffering_duration
     *
     * @return self
     */
    public function setBufferingDuration($buffering_duration)
    {

        if (is_null($buffering_duration)) {
            array_push($this->openAPINullablesSetToNull, 'buffering_duration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('buffering_duration', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['buffering_duration'] = $buffering_duration;

        return $this;
    }

    /**
     * Gets player_view_count
     *
     * @return int|null
     */
    public function getPlayerViewCount()
    {
        return $this->container['player_view_count'];
    }

    /**
     * Sets player_view_count
     *
     * @param int|null $player_view_count player_view_count
     *
     * @return self
     */
    public function setPlayerViewCount($player_view_count)
    {

        if (is_null($player_view_count)) {
            array_push($this->openAPINullablesSetToNull, 'player_view_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_view_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_view_count'] = $player_view_count;

        return $this;
    }

    /**
     * Gets player_software
     *
     * @return string|null
     */
    public function getPlayerSoftware()
    {
        return $this->container['player_software'];
    }

    /**
     * Sets player_software
     *
     * @param string|null $player_software player_software
     *
     * @return self
     */
    public function setPlayerSoftware($player_software)
    {

        if (is_null($player_software)) {
            array_push($this->openAPINullablesSetToNull, 'player_software');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_software', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_software'] = $player_software;

        return $this;
    }

    /**
     * Gets player_load_time
     *
     * @return int|null
     */
    public function getPlayerLoadTime()
    {
        return $this->container['player_load_time'];
    }

    /**
     * Sets player_load_time
     *
     * @param int|null $player_load_time player_load_time
     *
     * @return self
     */
    public function setPlayerLoadTime($player_load_time)
    {

        if (is_null($player_load_time)) {
            array_push($this->openAPINullablesSetToNull, 'player_load_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_load_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_load_time'] = $player_load_time;

        return $this;
    }

    /**
     * Gets platform_summary
     *
     * @return string|null
     */
    public function getPlatformSummary()
    {
        return $this->container['platform_summary'];
    }

    /**
     * Sets platform_summary
     *
     * @param string|null $platform_summary platform_summary
     *
     * @return self
     */
    public function setPlatformSummary($platform_summary)
    {

        if (is_null($platform_summary)) {
            array_push($this->openAPINullablesSetToNull, 'platform_summary');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('platform_summary', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['platform_summary'] = $platform_summary;

        return $this;
    }

    /**
     * Gets video_encoding_variant
     *
     * @return string|null
     */
    public function getVideoEncodingVariant()
    {
        return $this->container['video_encoding_variant'];
    }

    /**
     * Sets video_encoding_variant
     *
     * @param string|null $video_encoding_variant video_encoding_variant
     *
     * @return self
     */
    public function setVideoEncodingVariant($video_encoding_variant)
    {

        if (is_null($video_encoding_variant)) {
            array_push($this->openAPINullablesSetToNull, 'video_encoding_variant');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_encoding_variant', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_encoding_variant'] = $video_encoding_variant;

        return $this;
    }

    /**
     * Gets player_width
     *
     * @return int|null
     */
    public function getPlayerWidth()
    {
        return $this->container['player_width'];
    }

    /**
     * Sets player_width
     *
     * @param int|null $player_width player_width
     *
     * @return self
     */
    public function setPlayerWidth($player_width)
    {

        if (is_null($player_width)) {
            array_push($this->openAPINullablesSetToNull, 'player_width');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_width', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_width'] = $player_width;

        return $this;
    }

    /**
     * Gets view_seek_count
     *
     * @return int|null
     */
    public function getViewSeekCount()
    {
        return $this->container['view_seek_count'];
    }

    /**
     * Sets view_seek_count
     *
     * @param int|null $view_seek_count view_seek_count
     *
     * @return self
     */
    public function setViewSeekCount($view_seek_count)
    {

        if (is_null($view_seek_count)) {
            array_push($this->openAPINullablesSetToNull, 'view_seek_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_seek_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_seek_count'] = $view_seek_count;

        return $this;
    }

    /**
     * Gets viewer_experience_score
     *
     * @return string|null
     */
    public function getViewerExperienceScore()
    {
        return $this->container['viewer_experience_score'];
    }

    /**
     * Sets viewer_experience_score
     *
     * @param string|null $viewer_experience_score viewer_experience_score
     *
     * @return self
     */
    public function setViewerExperienceScore($viewer_experience_score)
    {

        if (is_null($viewer_experience_score)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_experience_score');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_experience_score', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_experience_score'] = $viewer_experience_score;

        return $this;
    }

    /**
     * Gets view_error_id
     *
     * @return int|null
     */
    public function getViewErrorId()
    {
        return $this->container['view_error_id'];
    }

    /**
     * Sets view_error_id
     *
     * @param int|null $view_error_id view_error_id
     *
     * @return self
     */
    public function setViewErrorId($view_error_id)
    {

        if (is_null($view_error_id)) {
            array_push($this->openAPINullablesSetToNull, 'view_error_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_error_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_error_id'] = $view_error_id;

        return $this;
    }

    /**
     * Gets video_variant_name
     *
     * @return string|null
     */
    public function getVideoVariantName()
    {
        return $this->container['video_variant_name'];
    }

    /**
     * Sets video_variant_name
     *
     * @param string|null $video_variant_name video_variant_name
     *
     * @return self
     */
    public function setVideoVariantName($video_variant_name)
    {

        if (is_null($video_variant_name)) {
            array_push($this->openAPINullablesSetToNull, 'video_variant_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_variant_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_variant_name'] = $video_variant_name;

        return $this;
    }

    /**
     * Gets preroll_played
     *
     * @return bool|null
     */
    public function getPrerollPlayed()
    {
        return $this->container['preroll_played'];
    }

    /**
     * Sets preroll_played
     *
     * @param bool|null $preroll_played preroll_played
     *
     * @return self
     */
    public function setPrerollPlayed($preroll_played)
    {

        if (is_null($preroll_played)) {
            array_push($this->openAPINullablesSetToNull, 'preroll_played');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('preroll_played', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['preroll_played'] = $preroll_played;

        return $this;
    }

    /**
     * Gets viewer_application_engine
     *
     * @return string|null
     */
    public function getViewerApplicationEngine()
    {
        return $this->container['viewer_application_engine'];
    }

    /**
     * Sets viewer_application_engine
     *
     * @param string|null $viewer_application_engine viewer_application_engine
     *
     * @return self
     */
    public function setViewerApplicationEngine($viewer_application_engine)
    {

        if (is_null($viewer_application_engine)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_application_engine');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_application_engine', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_application_engine'] = $viewer_application_engine;

        return $this;
    }

    /**
     * Gets viewer_os_architecture
     *
     * @return string|null
     */
    public function getViewerOsArchitecture()
    {
        return $this->container['viewer_os_architecture'];
    }

    /**
     * Sets viewer_os_architecture
     *
     * @param string|null $viewer_os_architecture viewer_os_architecture
     *
     * @return self
     */
    public function setViewerOsArchitecture($viewer_os_architecture)
    {

        if (is_null($viewer_os_architecture)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_os_architecture');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_os_architecture', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_os_architecture'] = $viewer_os_architecture;

        return $this;
    }

    /**
     * Gets player_error_code
     *
     * @return string|null
     */
    public function getPlayerErrorCode()
    {
        return $this->container['player_error_code'];
    }

    /**
     * Sets player_error_code
     *
     * @param string|null $player_error_code player_error_code
     *
     * @return self
     */
    public function setPlayerErrorCode($player_error_code)
    {

        if (is_null($player_error_code)) {
            array_push($this->openAPINullablesSetToNull, 'player_error_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_error_code', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_error_code'] = $player_error_code;

        return $this;
    }

    /**
     * Gets buffering_rate
     *
     * @return string|null
     */
    public function getBufferingRate()
    {
        return $this->container['buffering_rate'];
    }

    /**
     * Sets buffering_rate
     *
     * @param string|null $buffering_rate buffering_rate
     *
     * @return self
     */
    public function setBufferingRate($buffering_rate)
    {

        if (is_null($buffering_rate)) {
            array_push($this->openAPINullablesSetToNull, 'buffering_rate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('buffering_rate', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['buffering_rate'] = $buffering_rate;

        return $this;
    }

    /**
     * Gets events
     *
     * @return \MuxPhp\Models\VideoViewEvent[]|null
     */
    public function getEvents()
    {
        return $this->container['events'];
    }

    /**
     * Sets events
     *
     * @param \MuxPhp\Models\VideoViewEvent[]|null $events events
     *
     * @return self
     */
    public function setEvents($events)
    {

        if (is_null($events)) {
            throw new \InvalidArgumentException('non-nullable events cannot be null');
        }

        $this->container['events'] = $events;

        return $this;
    }

    /**
     * Gets player_name
     *
     * @return string|null
     */
    public function getPlayerName()
    {
        return $this->container['player_name'];
    }

    /**
     * Sets player_name
     *
     * @param string|null $player_name player_name
     *
     * @return self
     */
    public function setPlayerName($player_name)
    {

        if (is_null($player_name)) {
            array_push($this->openAPINullablesSetToNull, 'player_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_name'] = $player_name;

        return $this;
    }

    /**
     * Gets view_start
     *
     * @return string|null
     */
    public function getViewStart()
    {
        return $this->container['view_start'];
    }

    /**
     * Sets view_start
     *
     * @param string|null $view_start view_start
     *
     * @return self
     */
    public function setViewStart($view_start)
    {

        if (is_null($view_start)) {
            throw new \InvalidArgumentException('non-nullable view_start cannot be null');
        }

        $this->container['view_start'] = $view_start;

        return $this;
    }

    /**
     * Gets view_average_request_throughput
     *
     * @return int|null
     */
    public function getViewAverageRequestThroughput()
    {
        return $this->container['view_average_request_throughput'];
    }

    /**
     * Sets view_average_request_throughput
     *
     * @param int|null $view_average_request_throughput view_average_request_throughput
     *
     * @return self
     */
    public function setViewAverageRequestThroughput($view_average_request_throughput)
    {

        if (is_null($view_average_request_throughput)) {
            array_push($this->openAPINullablesSetToNull, 'view_average_request_throughput');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_average_request_throughput', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_average_request_throughput'] = $view_average_request_throughput;

        return $this;
    }

    /**
     * Gets video_producer
     *
     * @return string|null
     */
    public function getVideoProducer()
    {
        return $this->container['video_producer'];
    }

    /**
     * Sets video_producer
     *
     * @param string|null $video_producer video_producer
     *
     * @return self
     */
    public function setVideoProducer($video_producer)
    {

        if (is_null($video_producer)) {
            array_push($this->openAPINullablesSetToNull, 'video_producer');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_producer', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_producer'] = $video_producer;

        return $this;
    }

    /**
     * Gets error_type_id
     *
     * @return int|null
     */
    public function getErrorTypeId()
    {
        return $this->container['error_type_id'];
    }

    /**
     * Sets error_type_id
     *
     * @param int|null $error_type_id error_type_id
     *
     * @return self
     */
    public function setErrorTypeId($error_type_id)
    {

        if (is_null($error_type_id)) {
            array_push($this->openAPINullablesSetToNull, 'error_type_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('error_type_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['error_type_id'] = $error_type_id;

        return $this;
    }

    /**
     * Gets mux_viewer_id
     *
     * @return string|null
     */
    public function getMuxViewerId()
    {
        return $this->container['mux_viewer_id'];
    }

    /**
     * Sets mux_viewer_id
     *
     * @param string|null $mux_viewer_id mux_viewer_id
     *
     * @return self
     */
    public function setMuxViewerId($mux_viewer_id)
    {

        if (is_null($mux_viewer_id)) {
            throw new \InvalidArgumentException('non-nullable mux_viewer_id cannot be null');
        }

        $this->container['mux_viewer_id'] = $mux_viewer_id;

        return $this;
    }

    /**
     * Gets video_id
     *
     * @return string|null
     */
    public function getVideoId()
    {
        return $this->container['video_id'];
    }

    /**
     * Sets video_id
     *
     * @param string|null $video_id video_id
     *
     * @return self
     */
    public function setVideoId($video_id)
    {

        if (is_null($video_id)) {
            array_push($this->openAPINullablesSetToNull, 'video_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_id'] = $video_id;

        return $this;
    }

    /**
     * Gets continent_code
     *
     * @return string|null
     */
    public function getContinentCode()
    {
        return $this->container['continent_code'];
    }

    /**
     * Sets continent_code
     *
     * @param string|null $continent_code continent_code
     *
     * @return self
     */
    public function setContinentCode($continent_code)
    {

        if (is_null($continent_code)) {
            array_push($this->openAPINullablesSetToNull, 'continent_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('continent_code', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['continent_code'] = $continent_code;

        return $this;
    }

    /**
     * Gets session_id
     *
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->container['session_id'];
    }

    /**
     * Sets session_id
     *
     * @param string|null $session_id session_id
     *
     * @return self
     */
    public function setSessionId($session_id)
    {

        if (is_null($session_id)) {
            throw new \InvalidArgumentException('non-nullable session_id cannot be null');
        }

        $this->container['session_id'] = $session_id;

        return $this;
    }

    /**
     * Gets exit_before_video_start
     *
     * @return bool|null
     */
    public function getExitBeforeVideoStart()
    {
        return $this->container['exit_before_video_start'];
    }

    /**
     * Sets exit_before_video_start
     *
     * @param bool|null $exit_before_video_start exit_before_video_start
     *
     * @return self
     */
    public function setExitBeforeVideoStart($exit_before_video_start)
    {

        if (is_null($exit_before_video_start)) {
            throw new \InvalidArgumentException('non-nullable exit_before_video_start cannot be null');
        }

        $this->container['exit_before_video_start'] = $exit_before_video_start;

        return $this;
    }

    /**
     * Gets video_content_type
     *
     * @return string|null
     */
    public function getVideoContentType()
    {
        return $this->container['video_content_type'];
    }

    /**
     * Sets video_content_type
     *
     * @param string|null $video_content_type video_content_type
     *
     * @return self
     */
    public function setVideoContentType($video_content_type)
    {

        if (is_null($video_content_type)) {
            array_push($this->openAPINullablesSetToNull, 'video_content_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_content_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_content_type'] = $video_content_type;

        return $this;
    }

    /**
     * Gets viewer_os_family
     *
     * @return string|null
     */
    public function getViewerOsFamily()
    {
        return $this->container['viewer_os_family'];
    }

    /**
     * Sets viewer_os_family
     *
     * @param string|null $viewer_os_family viewer_os_family
     *
     * @return self
     */
    public function setViewerOsFamily($viewer_os_family)
    {

        if (is_null($viewer_os_family)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_os_family');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_os_family', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_os_family'] = $viewer_os_family;

        return $this;
    }

    /**
     * Gets player_poster
     *
     * @return string|null
     */
    public function getPlayerPoster()
    {
        return $this->container['player_poster'];
    }

    /**
     * Sets player_poster
     *
     * @param string|null $player_poster player_poster
     *
     * @return self
     */
    public function setPlayerPoster($player_poster)
    {

        if (is_null($player_poster)) {
            array_push($this->openAPINullablesSetToNull, 'player_poster');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_poster', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_poster'] = $player_poster;

        return $this;
    }

    /**
     * Gets view_average_request_latency
     *
     * @return int|null
     */
    public function getViewAverageRequestLatency()
    {
        return $this->container['view_average_request_latency'];
    }

    /**
     * Sets view_average_request_latency
     *
     * @param int|null $view_average_request_latency view_average_request_latency
     *
     * @return self
     */
    public function setViewAverageRequestLatency($view_average_request_latency)
    {

        if (is_null($view_average_request_latency)) {
            array_push($this->openAPINullablesSetToNull, 'view_average_request_latency');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_average_request_latency', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_average_request_latency'] = $view_average_request_latency;

        return $this;
    }

    /**
     * Gets video_variant_id
     *
     * @return string|null
     */
    public function getVideoVariantId()
    {
        return $this->container['video_variant_id'];
    }

    /**
     * Sets video_variant_id
     *
     * @param string|null $video_variant_id video_variant_id
     *
     * @return self
     */
    public function setVideoVariantId($video_variant_id)
    {

        if (is_null($video_variant_id)) {
            array_push($this->openAPINullablesSetToNull, 'video_variant_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_variant_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_variant_id'] = $video_variant_id;

        return $this;
    }

    /**
     * Gets player_source_duration
     *
     * @return int|null
     */
    public function getPlayerSourceDuration()
    {
        return $this->container['player_source_duration'];
    }

    /**
     * Sets player_source_duration
     *
     * @param int|null $player_source_duration player_source_duration
     *
     * @return self
     */
    public function setPlayerSourceDuration($player_source_duration)
    {

        if (is_null($player_source_duration)) {
            array_push($this->openAPINullablesSetToNull, 'player_source_duration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_source_duration', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_source_duration'] = $player_source_duration;

        return $this;
    }

    /**
     * Gets player_source_url
     *
     * @return string|null
     */
    public function getPlayerSourceUrl()
    {
        return $this->container['player_source_url'];
    }

    /**
     * Sets player_source_url
     *
     * @param string|null $player_source_url player_source_url
     *
     * @return self
     */
    public function setPlayerSourceUrl($player_source_url)
    {

        if (is_null($player_source_url)) {
            array_push($this->openAPINullablesSetToNull, 'player_source_url');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_source_url', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_source_url'] = $player_source_url;

        return $this;
    }

    /**
     * Gets mux_api_version
     *
     * @return string|null
     */
    public function getMuxApiVersion()
    {
        return $this->container['mux_api_version'];
    }

    /**
     * Sets mux_api_version
     *
     * @param string|null $mux_api_version mux_api_version
     *
     * @return self
     */
    public function setMuxApiVersion($mux_api_version)
    {

        if (is_null($mux_api_version)) {
            throw new \InvalidArgumentException('non-nullable mux_api_version cannot be null');
        }

        $this->container['mux_api_version'] = $mux_api_version;

        return $this;
    }

    /**
     * Gets video_title
     *
     * @return string|null
     */
    public function getVideoTitle()
    {
        return $this->container['video_title'];
    }

    /**
     * Sets video_title
     *
     * @param string|null $video_title video_title
     *
     * @return self
     */
    public function setVideoTitle($video_title)
    {

        if (is_null($video_title)) {
            array_push($this->openAPINullablesSetToNull, 'video_title');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_title', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_title'] = $video_title;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {

        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }

        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets short_time
     *
     * @return string|null
     */
    public function getShortTime()
    {
        return $this->container['short_time'];
    }

    /**
     * Sets short_time
     *
     * @param string|null $short_time short_time
     *
     * @return self
     */
    public function setShortTime($short_time)
    {

        if (is_null($short_time)) {
            throw new \InvalidArgumentException('non-nullable short_time cannot be null');
        }

        $this->container['short_time'] = $short_time;

        return $this;
    }

    /**
     * Gets rebuffer_percentage
     *
     * @return string|null
     */
    public function getRebufferPercentage()
    {
        return $this->container['rebuffer_percentage'];
    }

    /**
     * Sets rebuffer_percentage
     *
     * @param string|null $rebuffer_percentage rebuffer_percentage
     *
     * @return self
     */
    public function setRebufferPercentage($rebuffer_percentage)
    {

        if (is_null($rebuffer_percentage)) {
            array_push($this->openAPINullablesSetToNull, 'rebuffer_percentage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rebuffer_percentage', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['rebuffer_percentage'] = $rebuffer_percentage;

        return $this;
    }

    /**
     * Gets time_to_first_frame
     *
     * @return int|null
     */
    public function getTimeToFirstFrame()
    {
        return $this->container['time_to_first_frame'];
    }

    /**
     * Sets time_to_first_frame
     *
     * @param int|null $time_to_first_frame time_to_first_frame
     *
     * @return self
     */
    public function setTimeToFirstFrame($time_to_first_frame)
    {

        if (is_null($time_to_first_frame)) {
            array_push($this->openAPINullablesSetToNull, 'time_to_first_frame');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('time_to_first_frame', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['time_to_first_frame'] = $time_to_first_frame;

        return $this;
    }

    /**
     * Gets viewer_user_id
     *
     * @return string|null
     */
    public function getViewerUserId()
    {
        return $this->container['viewer_user_id'];
    }

    /**
     * Sets viewer_user_id
     *
     * @param string|null $viewer_user_id viewer_user_id
     *
     * @return self
     */
    public function setViewerUserId($viewer_user_id)
    {

        if (is_null($viewer_user_id)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_user_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_user_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_user_id'] = $viewer_user_id;

        return $this;
    }

    /**
     * Gets video_stream_type
     *
     * @return string|null
     */
    public function getVideoStreamType()
    {
        return $this->container['video_stream_type'];
    }

    /**
     * Sets video_stream_type
     *
     * @param string|null $video_stream_type video_stream_type
     *
     * @return self
     */
    public function setVideoStreamType($video_stream_type)
    {

        if (is_null($video_stream_type)) {
            array_push($this->openAPINullablesSetToNull, 'video_stream_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_stream_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_stream_type'] = $video_stream_type;

        return $this;
    }

    /**
     * Gets player_startup_time
     *
     * @return int|null
     */
    public function getPlayerStartupTime()
    {
        return $this->container['player_startup_time'];
    }

    /**
     * Sets player_startup_time
     *
     * @param int|null $player_startup_time player_startup_time
     *
     * @return self
     */
    public function setPlayerStartupTime($player_startup_time)
    {

        if (is_null($player_startup_time)) {
            array_push($this->openAPINullablesSetToNull, 'player_startup_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_startup_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_startup_time'] = $player_startup_time;

        return $this;
    }

    /**
     * Gets viewer_application_version
     *
     * @return string|null
     */
    public function getViewerApplicationVersion()
    {
        return $this->container['viewer_application_version'];
    }

    /**
     * Sets viewer_application_version
     *
     * @param string|null $viewer_application_version viewer_application_version
     *
     * @return self
     */
    public function setViewerApplicationVersion($viewer_application_version)
    {

        if (is_null($viewer_application_version)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_application_version');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_application_version', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_application_version'] = $viewer_application_version;

        return $this;
    }

    /**
     * Gets view_max_downscale_percentage
     *
     * @return string|null
     */
    public function getViewMaxDownscalePercentage()
    {
        return $this->container['view_max_downscale_percentage'];
    }

    /**
     * Sets view_max_downscale_percentage
     *
     * @param string|null $view_max_downscale_percentage view_max_downscale_percentage
     *
     * @return self
     */
    public function setViewMaxDownscalePercentage($view_max_downscale_percentage)
    {

        if (is_null($view_max_downscale_percentage)) {
            array_push($this->openAPINullablesSetToNull, 'view_max_downscale_percentage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_max_downscale_percentage', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_max_downscale_percentage'] = $view_max_downscale_percentage;

        return $this;
    }

    /**
     * Gets view_max_upscale_percentage
     *
     * @return string|null
     */
    public function getViewMaxUpscalePercentage()
    {
        return $this->container['view_max_upscale_percentage'];
    }

    /**
     * Sets view_max_upscale_percentage
     *
     * @param string|null $view_max_upscale_percentage view_max_upscale_percentage
     *
     * @return self
     */
    public function setViewMaxUpscalePercentage($view_max_upscale_percentage)
    {

        if (is_null($view_max_upscale_percentage)) {
            array_push($this->openAPINullablesSetToNull, 'view_max_upscale_percentage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_max_upscale_percentage', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_max_upscale_percentage'] = $view_max_upscale_percentage;

        return $this;
    }

    /**
     * Gets country_code
     *
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->container['country_code'];
    }

    /**
     * Sets country_code
     *
     * @param string|null $country_code country_code
     *
     * @return self
     */
    public function setCountryCode($country_code)
    {

        if (is_null($country_code)) {
            array_push($this->openAPINullablesSetToNull, 'country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('country_code', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['country_code'] = $country_code;

        return $this;
    }

    /**
     * Gets used_fullscreen
     *
     * @return bool|null
     */
    public function getUsedFullscreen()
    {
        return $this->container['used_fullscreen'];
    }

    /**
     * Sets used_fullscreen
     *
     * @param bool|null $used_fullscreen used_fullscreen
     *
     * @return self
     */
    public function setUsedFullscreen($used_fullscreen)
    {

        if (is_null($used_fullscreen)) {
            throw new \InvalidArgumentException('non-nullable used_fullscreen cannot be null');
        }

        $this->container['used_fullscreen'] = $used_fullscreen;

        return $this;
    }

    /**
     * Gets isp
     *
     * @return string|null
     */
    public function getIsp()
    {
        return $this->container['isp'];
    }

    /**
     * Sets isp
     *
     * @param string|null $isp isp
     *
     * @return self
     */
    public function setIsp($isp)
    {

        if (is_null($isp)) {
            array_push($this->openAPINullablesSetToNull, 'isp');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('isp', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['isp'] = $isp;

        return $this;
    }

    /**
     * Gets property_id
     *
     * @return int|null
     */
    public function getPropertyId()
    {
        return $this->container['property_id'];
    }

    /**
     * Sets property_id
     *
     * @param int|null $property_id property_id
     *
     * @return self
     */
    public function setPropertyId($property_id)
    {

        if (is_null($property_id)) {
            throw new \InvalidArgumentException('non-nullable property_id cannot be null');
        }

        $this->container['property_id'] = $property_id;

        return $this;
    }

    /**
     * Gets player_autoplay
     *
     * @return bool|null
     */
    public function getPlayerAutoplay()
    {
        return $this->container['player_autoplay'];
    }

    /**
     * Sets player_autoplay
     *
     * @param bool|null $player_autoplay player_autoplay
     *
     * @return self
     */
    public function setPlayerAutoplay($player_autoplay)
    {

        if (is_null($player_autoplay)) {
            throw new \InvalidArgumentException('non-nullable player_autoplay cannot be null');
        }

        $this->container['player_autoplay'] = $player_autoplay;

        return $this;
    }

    /**
     * Gets player_height
     *
     * @return int|null
     */
    public function getPlayerHeight()
    {
        return $this->container['player_height'];
    }

    /**
     * Sets player_height
     *
     * @param int|null $player_height player_height
     *
     * @return self
     */
    public function setPlayerHeight($player_height)
    {

        if (is_null($player_height)) {
            array_push($this->openAPINullablesSetToNull, 'player_height');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_height', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_height'] = $player_height;

        return $this;
    }

    /**
     * Gets asn
     *
     * @return int|null
     */
    public function getAsn()
    {
        return $this->container['asn'];
    }

    /**
     * Sets asn
     *
     * @param int|null $asn asn
     *
     * @return self
     */
    public function setAsn($asn)
    {

        if (is_null($asn)) {
            array_push($this->openAPINullablesSetToNull, 'asn');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('asn', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['asn'] = $asn;

        return $this;
    }

    /**
     * Gets asn_name
     *
     * @return string|null
     */
    public function getAsnName()
    {
        return $this->container['asn_name'];
    }

    /**
     * Sets asn_name
     *
     * @param string|null $asn_name asn_name
     *
     * @return self
     */
    public function setAsnName($asn_name)
    {

        if (is_null($asn_name)) {
            array_push($this->openAPINullablesSetToNull, 'asn_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('asn_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['asn_name'] = $asn_name;

        return $this;
    }

    /**
     * Gets quality_score
     *
     * @return string|null
     */
    public function getQualityScore()
    {
        return $this->container['quality_score'];
    }

    /**
     * Sets quality_score
     *
     * @param string|null $quality_score quality_score
     *
     * @return self
     */
    public function setQualityScore($quality_score)
    {

        if (is_null($quality_score)) {
            array_push($this->openAPINullablesSetToNull, 'quality_score');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('quality_score', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['quality_score'] = $quality_score;

        return $this;
    }

    /**
     * Gets player_software_version
     *
     * @return string|null
     */
    public function getPlayerSoftwareVersion()
    {
        return $this->container['player_software_version'];
    }

    /**
     * Sets player_software_version
     *
     * @param string|null $player_software_version player_software_version
     *
     * @return self
     */
    public function setPlayerSoftwareVersion($player_software_version)
    {

        if (is_null($player_software_version)) {
            array_push($this->openAPINullablesSetToNull, 'player_software_version');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_software_version', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_software_version'] = $player_software_version;

        return $this;
    }

    /**
     * Gets player_mux_plugin_name
     *
     * @return string|null
     */
    public function getPlayerMuxPluginName()
    {
        return $this->container['player_mux_plugin_name'];
    }

    /**
     * Sets player_mux_plugin_name
     *
     * @param string|null $player_mux_plugin_name player_mux_plugin_name
     *
     * @return self
     */
    public function setPlayerMuxPluginName($player_mux_plugin_name)
    {

        if (is_null($player_mux_plugin_name)) {
            array_push($this->openAPINullablesSetToNull, 'player_mux_plugin_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_mux_plugin_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_mux_plugin_name'] = $player_mux_plugin_name;

        return $this;
    }

    /**
     * Gets sub_property_id
     *
     * @return string|null
     */
    public function getSubPropertyId()
    {
        return $this->container['sub_property_id'];
    }

    /**
     * Sets sub_property_id
     *
     * @param string|null $sub_property_id sub_property_id
     *
     * @return self
     */
    public function setSubPropertyId($sub_property_id)
    {

        if (is_null($sub_property_id)) {
            array_push($this->openAPINullablesSetToNull, 'sub_property_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sub_property_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['sub_property_id'] = $sub_property_id;

        return $this;
    }

    /**
     * Gets player_remote_played
     *
     * @return bool|null
     */
    public function getPlayerRemotePlayed()
    {
        return $this->container['player_remote_played'];
    }

    /**
     * Sets player_remote_played
     *
     * @param bool|null $player_remote_played player_remote_played
     *
     * @return self
     */
    public function setPlayerRemotePlayed($player_remote_played)
    {

        if (is_null($player_remote_played)) {
            array_push($this->openAPINullablesSetToNull, 'player_remote_played');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_remote_played', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_remote_played'] = $player_remote_played;

        return $this;
    }

    /**
     * Gets view_max_playhead_position
     *
     * @return string|null
     */
    public function getViewMaxPlayheadPosition()
    {
        return $this->container['view_max_playhead_position'];
    }

    /**
     * Sets view_max_playhead_position
     *
     * @param string|null $view_max_playhead_position view_max_playhead_position
     *
     * @return self
     */
    public function setViewMaxPlayheadPosition($view_max_playhead_position)
    {

        if (is_null($view_max_playhead_position)) {
            array_push($this->openAPINullablesSetToNull, 'view_max_playhead_position');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_max_playhead_position', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_max_playhead_position'] = $view_max_playhead_position;

        return $this;
    }

    /**
     * Gets view_playing_time
     *
     * @return string|null
     */
    public function getViewPlayingTime()
    {
        return $this->container['view_playing_time'];
    }

    /**
     * Sets view_playing_time
     *
     * @param string|null $view_playing_time view_playing_time
     *
     * @return self
     */
    public function setViewPlayingTime($view_playing_time)
    {

        if (is_null($view_playing_time)) {
            array_push($this->openAPINullablesSetToNull, 'view_playing_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_playing_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_playing_time'] = $view_playing_time;

        return $this;
    }

    /**
     * Gets view_session_id
     *
     * @return string|null
     */
    public function getViewSessionId()
    {
        return $this->container['view_session_id'];
    }

    /**
     * Sets view_session_id
     *
     * @param string|null $view_session_id view_session_id
     *
     * @return self
     */
    public function setViewSessionId($view_session_id)
    {

        if (is_null($view_session_id)) {
            array_push($this->openAPINullablesSetToNull, 'view_session_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_session_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_session_id'] = $view_session_id;

        return $this;
    }

    /**
     * Gets viewer_connection_type
     *
     * @return string|null
     */
    public function getViewerConnectionType()
    {
        return $this->container['viewer_connection_type'];
    }

    /**
     * Sets viewer_connection_type
     *
     * @param string|null $viewer_connection_type viewer_connection_type
     *
     * @return self
     */
    public function setViewerConnectionType($viewer_connection_type)
    {

        if (is_null($viewer_connection_type)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_connection_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_connection_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_connection_type'] = $viewer_connection_type;

        return $this;
    }

    /**
     * Gets viewer_device_model
     *
     * @return string|null
     */
    public function getViewerDeviceModel()
    {
        return $this->container['viewer_device_model'];
    }

    /**
     * Sets viewer_device_model
     *
     * @param string|null $viewer_device_model viewer_device_model
     *
     * @return self
     */
    public function setViewerDeviceModel($viewer_device_model)
    {

        if (is_null($viewer_device_model)) {
            array_push($this->openAPINullablesSetToNull, 'viewer_device_model');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewer_device_model', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['viewer_device_model'] = $viewer_device_model;

        return $this;
    }

    /**
     * Gets weighted_average_bitrate
     *
     * @return double|null
     */
    public function getWeightedAverageBitrate()
    {
        return $this->container['weighted_average_bitrate'];
    }

    /**
     * Sets weighted_average_bitrate
     *
     * @param double|null $weighted_average_bitrate weighted_average_bitrate
     *
     * @return self
     */
    public function setWeightedAverageBitrate($weighted_average_bitrate)
    {

        if (is_null($weighted_average_bitrate)) {
            array_push($this->openAPINullablesSetToNull, 'weighted_average_bitrate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('weighted_average_bitrate', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['weighted_average_bitrate'] = $weighted_average_bitrate;

        return $this;
    }

    /**
     * Gets custom_1
     *
     * @return string|null
     */
    public function getCustom1()
    {
        return $this->container['custom_1'];
    }

    /**
     * Sets custom_1
     *
     * @param string|null $custom_1 custom_1
     *
     * @return self
     */
    public function setCustom1($custom_1)
    {

        if (is_null($custom_1)) {
            array_push($this->openAPINullablesSetToNull, 'custom_1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_1', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['custom_1'] = $custom_1;

        return $this;
    }

    /**
     * Gets custom_2
     *
     * @return string|null
     */
    public function getCustom2()
    {
        return $this->container['custom_2'];
    }

    /**
     * Sets custom_2
     *
     * @param string|null $custom_2 custom_2
     *
     * @return self
     */
    public function setCustom2($custom_2)
    {

        if (is_null($custom_2)) {
            array_push($this->openAPINullablesSetToNull, 'custom_2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_2', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['custom_2'] = $custom_2;

        return $this;
    }

    /**
     * Gets custom_3
     *
     * @return string|null
     */
    public function getCustom3()
    {
        return $this->container['custom_3'];
    }

    /**
     * Sets custom_3
     *
     * @param string|null $custom_3 custom_3
     *
     * @return self
     */
    public function setCustom3($custom_3)
    {

        if (is_null($custom_3)) {
            array_push($this->openAPINullablesSetToNull, 'custom_3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_3', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['custom_3'] = $custom_3;

        return $this;
    }

    /**
     * Gets custom_4
     *
     * @return string|null
     */
    public function getCustom4()
    {
        return $this->container['custom_4'];
    }

    /**
     * Sets custom_4
     *
     * @param string|null $custom_4 custom_4
     *
     * @return self
     */
    public function setCustom4($custom_4)
    {

        if (is_null($custom_4)) {
            array_push($this->openAPINullablesSetToNull, 'custom_4');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_4', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['custom_4'] = $custom_4;

        return $this;
    }

    /**
     * Gets custom_5
     *
     * @return string|null
     */
    public function getCustom5()
    {
        return $this->container['custom_5'];
    }

    /**
     * Sets custom_5
     *
     * @param string|null $custom_5 custom_5
     *
     * @return self
     */
    public function setCustom5($custom_5)
    {

        if (is_null($custom_5)) {
            array_push($this->openAPINullablesSetToNull, 'custom_5');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_5', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['custom_5'] = $custom_5;

        return $this;
    }

    /**
     * Gets custom_6
     *
     * @return string|null
     */
    public function getCustom6()
    {
        return $this->container['custom_6'];
    }

    /**
     * Sets custom_6
     *
     * @param string|null $custom_6 custom_6
     *
     * @return self
     */
    public function setCustom6($custom_6)
    {

        if (is_null($custom_6)) {
            array_push($this->openAPINullablesSetToNull, 'custom_6');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_6', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['custom_6'] = $custom_6;

        return $this;
    }

    /**
     * Gets custom_7
     *
     * @return string|null
     */
    public function getCustom7()
    {
        return $this->container['custom_7'];
    }

    /**
     * Sets custom_7
     *
     * @param string|null $custom_7 custom_7
     *
     * @return self
     */
    public function setCustom7($custom_7)
    {

        if (is_null($custom_7)) {
            array_push($this->openAPINullablesSetToNull, 'custom_7');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_7', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['custom_7'] = $custom_7;

        return $this;
    }

    /**
     * Gets custom_8
     *
     * @return string|null
     */
    public function getCustom8()
    {
        return $this->container['custom_8'];
    }

    /**
     * Sets custom_8
     *
     * @param string|null $custom_8 custom_8
     *
     * @return self
     */
    public function setCustom8($custom_8)
    {

        if (is_null($custom_8)) {
            array_push($this->openAPINullablesSetToNull, 'custom_8');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_8', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['custom_8'] = $custom_8;

        return $this;
    }

    /**
     * Gets custom_9
     *
     * @return string|null
     */
    public function getCustom9()
    {
        return $this->container['custom_9'];
    }

    /**
     * Sets custom_9
     *
     * @param string|null $custom_9 custom_9
     *
     * @return self
     */
    public function setCustom9($custom_9)
    {

        if (is_null($custom_9)) {
            array_push($this->openAPINullablesSetToNull, 'custom_9');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_9', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['custom_9'] = $custom_9;

        return $this;
    }

    /**
     * Gets custom_10
     *
     * @return string|null
     */
    public function getCustom10()
    {
        return $this->container['custom_10'];
    }

    /**
     * Sets custom_10
     *
     * @param string|null $custom_10 custom_10
     *
     * @return self
     */
    public function setCustom10($custom_10)
    {

        if (is_null($custom_10)) {
            array_push($this->openAPINullablesSetToNull, 'custom_10');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_10', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['custom_10'] = $custom_10;

        return $this;
    }

    /**
     * Gets live_stream_latency
     *
     * @return int|null
     */
    public function getLiveStreamLatency()
    {
        return $this->container['live_stream_latency'];
    }

    /**
     * Sets live_stream_latency
     *
     * @param int|null $live_stream_latency live_stream_latency
     *
     * @return self
     */
    public function setLiveStreamLatency($live_stream_latency)
    {

        if (is_null($live_stream_latency)) {
            array_push($this->openAPINullablesSetToNull, 'live_stream_latency');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('live_stream_latency', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['live_stream_latency'] = $live_stream_latency;

        return $this;
    }

    /**
     * Gets asset_id
     *
     * @return string|null
     */
    public function getAssetId()
    {
        return $this->container['asset_id'];
    }

    /**
     * Sets asset_id
     *
     * @param string|null $asset_id asset_id
     *
     * @return self
     */
    public function setAssetId($asset_id)
    {

        if (is_null($asset_id)) {
            array_push($this->openAPINullablesSetToNull, 'asset_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('asset_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['asset_id'] = $asset_id;

        return $this;
    }

    /**
     * Gets environment_id
     *
     * @return string|null
     */
    public function getEnvironmentId()
    {
        return $this->container['environment_id'];
    }

    /**
     * Sets environment_id
     *
     * @param string|null $environment_id environment_id
     *
     * @return self
     */
    public function setEnvironmentId($environment_id)
    {

        if (is_null($environment_id)) {
            throw new \InvalidArgumentException('non-nullable environment_id cannot be null');
        }

        $this->container['environment_id'] = $environment_id;

        return $this;
    }

    /**
     * Gets live_stream_id
     *
     * @return string|null
     */
    public function getLiveStreamId()
    {
        return $this->container['live_stream_id'];
    }

    /**
     * Sets live_stream_id
     *
     * @param string|null $live_stream_id live_stream_id
     *
     * @return self
     */
    public function setLiveStreamId($live_stream_id)
    {

        if (is_null($live_stream_id)) {
            array_push($this->openAPINullablesSetToNull, 'live_stream_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('live_stream_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['live_stream_id'] = $live_stream_id;

        return $this;
    }

    /**
     * Gets mux_embed
     *
     * @return string|null
     */
    public function getMuxEmbed()
    {
        return $this->container['mux_embed'];
    }

    /**
     * Sets mux_embed
     *
     * @param string|null $mux_embed mux_embed
     *
     * @return self
     */
    public function setMuxEmbed($mux_embed)
    {

        if (is_null($mux_embed)) {
            array_push($this->openAPINullablesSetToNull, 'mux_embed');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('mux_embed', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['mux_embed'] = $mux_embed;

        return $this;
    }

    /**
     * Gets playback_id
     *
     * @return string|null
     */
    public function getPlaybackId()
    {
        return $this->container['playback_id'];
    }

    /**
     * Sets playback_id
     *
     * @param string|null $playback_id playback_id
     *
     * @return self
     */
    public function setPlaybackId($playback_id)
    {

        if (is_null($playback_id)) {
            array_push($this->openAPINullablesSetToNull, 'playback_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('playback_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['playback_id'] = $playback_id;

        return $this;
    }

    /**
     * Gets player_error_context
     *
     * @return string|null
     */
    public function getPlayerErrorContext()
    {
        return $this->container['player_error_context'];
    }

    /**
     * Sets player_error_context
     *
     * @param string|null $player_error_context player_error_context
     *
     * @return self
     */
    public function setPlayerErrorContext($player_error_context)
    {

        if (is_null($player_error_context)) {
            array_push($this->openAPINullablesSetToNull, 'player_error_context');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('player_error_context', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['player_error_context'] = $player_error_context;

        return $this;
    }

    /**
     * Gets view_drm_type
     *
     * @return string|null
     */
    public function getViewDrmType()
    {
        return $this->container['view_drm_type'];
    }

    /**
     * Sets view_drm_type
     *
     * @param string|null $view_drm_type view_drm_type
     *
     * @return self
     */
    public function setViewDrmType($view_drm_type)
    {

        if (is_null($view_drm_type)) {
            array_push($this->openAPINullablesSetToNull, 'view_drm_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_drm_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_drm_type'] = $view_drm_type;

        return $this;
    }

    /**
     * Gets view_dropped_frame_count
     *
     * @return int|null
     */
    public function getViewDroppedFrameCount()
    {
        return $this->container['view_dropped_frame_count'];
    }

    /**
     * Sets view_dropped_frame_count
     *
     * @param int|null $view_dropped_frame_count view_dropped_frame_count
     *
     * @return self
     */
    public function setViewDroppedFrameCount($view_dropped_frame_count)
    {

        if (is_null($view_dropped_frame_count)) {
            array_push($this->openAPINullablesSetToNull, 'view_dropped_frame_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_dropped_frame_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_dropped_frame_count'] = $view_dropped_frame_count;

        return $this;
    }

    /**
     * Gets view_has_ad
     *
     * @return bool|null
     */
    public function getViewHasAd()
    {
        return $this->container['view_has_ad'];
    }

    /**
     * Sets view_has_ad
     *
     * @param bool|null $view_has_ad view_has_ad
     *
     * @return self
     */
    public function setViewHasAd($view_has_ad)
    {

        if (is_null($view_has_ad)) {
            throw new \InvalidArgumentException('non-nullable view_has_ad cannot be null');
        }

        $this->container['view_has_ad'] = $view_has_ad;

        return $this;
    }

    /**
     * Gets video_startup_failure
     *
     * @return bool|null
     */
    public function getVideoStartupFailure()
    {
        return $this->container['video_startup_failure'];
    }

    /**
     * Sets video_startup_failure
     *
     * @param bool|null $video_startup_failure video_startup_failure
     *
     * @return self
     */
    public function setVideoStartupFailure($video_startup_failure)
    {

        if (is_null($video_startup_failure)) {
            throw new \InvalidArgumentException('non-nullable video_startup_failure cannot be null');
        }

        $this->container['video_startup_failure'] = $video_startup_failure;

        return $this;
    }

    /**
     * Gets ad_attempt_count
     *
     * @return int|null
     */
    public function getAdAttemptCount()
    {
        return $this->container['ad_attempt_count'];
    }

    /**
     * Sets ad_attempt_count
     *
     * @param int|null $ad_attempt_count ad_attempt_count
     *
     * @return self
     */
    public function setAdAttemptCount($ad_attempt_count)
    {

        if (is_null($ad_attempt_count)) {
            array_push($this->openAPINullablesSetToNull, 'ad_attempt_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_attempt_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_attempt_count'] = $ad_attempt_count;

        return $this;
    }

    /**
     * Gets ad_break_count
     *
     * @return int|null
     */
    public function getAdBreakCount()
    {
        return $this->container['ad_break_count'];
    }

    /**
     * Sets ad_break_count
     *
     * @param int|null $ad_break_count ad_break_count
     *
     * @return self
     */
    public function setAdBreakCount($ad_break_count)
    {

        if (is_null($ad_break_count)) {
            array_push($this->openAPINullablesSetToNull, 'ad_break_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_break_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_break_count'] = $ad_break_count;

        return $this;
    }

    /**
     * Gets ad_break_error_count
     *
     * @return int|null
     */
    public function getAdBreakErrorCount()
    {
        return $this->container['ad_break_error_count'];
    }

    /**
     * Sets ad_break_error_count
     *
     * @param int|null $ad_break_error_count ad_break_error_count
     *
     * @return self
     */
    public function setAdBreakErrorCount($ad_break_error_count)
    {

        if (is_null($ad_break_error_count)) {
            array_push($this->openAPINullablesSetToNull, 'ad_break_error_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_break_error_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_break_error_count'] = $ad_break_error_count;

        return $this;
    }

    /**
     * Gets ad_break_error_percentage
     *
     * @return string|null
     */
    public function getAdBreakErrorPercentage()
    {
        return $this->container['ad_break_error_percentage'];
    }

    /**
     * Sets ad_break_error_percentage
     *
     * @param string|null $ad_break_error_percentage ad_break_error_percentage
     *
     * @return self
     */
    public function setAdBreakErrorPercentage($ad_break_error_percentage)
    {

        if (is_null($ad_break_error_percentage)) {
            array_push($this->openAPINullablesSetToNull, 'ad_break_error_percentage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_break_error_percentage', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_break_error_percentage'] = $ad_break_error_percentage;

        return $this;
    }

    /**
     * Gets ad_error_count
     *
     * @return int|null
     */
    public function getAdErrorCount()
    {
        return $this->container['ad_error_count'];
    }

    /**
     * Sets ad_error_count
     *
     * @param int|null $ad_error_count ad_error_count
     *
     * @return self
     */
    public function setAdErrorCount($ad_error_count)
    {

        if (is_null($ad_error_count)) {
            array_push($this->openAPINullablesSetToNull, 'ad_error_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_error_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_error_count'] = $ad_error_count;

        return $this;
    }

    /**
     * Gets ad_error_percentage
     *
     * @return string|null
     */
    public function getAdErrorPercentage()
    {
        return $this->container['ad_error_percentage'];
    }

    /**
     * Sets ad_error_percentage
     *
     * @param string|null $ad_error_percentage ad_error_percentage
     *
     * @return self
     */
    public function setAdErrorPercentage($ad_error_percentage)
    {

        if (is_null($ad_error_percentage)) {
            array_push($this->openAPINullablesSetToNull, 'ad_error_percentage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_error_percentage', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_error_percentage'] = $ad_error_percentage;

        return $this;
    }

    /**
     * Gets ad_impression_count
     *
     * @return int|null
     */
    public function getAdImpressionCount()
    {
        return $this->container['ad_impression_count'];
    }

    /**
     * Sets ad_impression_count
     *
     * @param int|null $ad_impression_count ad_impression_count
     *
     * @return self
     */
    public function setAdImpressionCount($ad_impression_count)
    {

        if (is_null($ad_impression_count)) {
            array_push($this->openAPINullablesSetToNull, 'ad_impression_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_impression_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_impression_count'] = $ad_impression_count;

        return $this;
    }

    /**
     * Gets ad_startup_error_count
     *
     * @return int|null
     */
    public function getAdStartupErrorCount()
    {
        return $this->container['ad_startup_error_count'];
    }

    /**
     * Sets ad_startup_error_count
     *
     * @param int|null $ad_startup_error_count ad_startup_error_count
     *
     * @return self
     */
    public function setAdStartupErrorCount($ad_startup_error_count)
    {

        if (is_null($ad_startup_error_count)) {
            array_push($this->openAPINullablesSetToNull, 'ad_startup_error_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_startup_error_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_startup_error_count'] = $ad_startup_error_count;

        return $this;
    }

    /**
     * Gets ad_startup_error_percentage
     *
     * @return string|null
     */
    public function getAdStartupErrorPercentage()
    {
        return $this->container['ad_startup_error_percentage'];
    }

    /**
     * Sets ad_startup_error_percentage
     *
     * @param string|null $ad_startup_error_percentage ad_startup_error_percentage
     *
     * @return self
     */
    public function setAdStartupErrorPercentage($ad_startup_error_percentage)
    {

        if (is_null($ad_startup_error_percentage)) {
            array_push($this->openAPINullablesSetToNull, 'ad_startup_error_percentage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_startup_error_percentage', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_startup_error_percentage'] = $ad_startup_error_percentage;

        return $this;
    }

    /**
     * Gets ad_exit_before_start_count
     *
     * @return int|null
     */
    public function getAdExitBeforeStartCount()
    {
        return $this->container['ad_exit_before_start_count'];
    }

    /**
     * Sets ad_exit_before_start_count
     *
     * @param int|null $ad_exit_before_start_count ad_exit_before_start_count
     *
     * @return self
     */
    public function setAdExitBeforeStartCount($ad_exit_before_start_count)
    {

        if (is_null($ad_exit_before_start_count)) {
            array_push($this->openAPINullablesSetToNull, 'ad_exit_before_start_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_exit_before_start_count', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_exit_before_start_count'] = $ad_exit_before_start_count;

        return $this;
    }

    /**
     * Gets ad_exit_before_start_percentage
     *
     * @return string|null
     */
    public function getAdExitBeforeStartPercentage()
    {
        return $this->container['ad_exit_before_start_percentage'];
    }

    /**
     * Sets ad_exit_before_start_percentage
     *
     * @param string|null $ad_exit_before_start_percentage ad_exit_before_start_percentage
     *
     * @return self
     */
    public function setAdExitBeforeStartPercentage($ad_exit_before_start_percentage)
    {

        if (is_null($ad_exit_before_start_percentage)) {
            array_push($this->openAPINullablesSetToNull, 'ad_exit_before_start_percentage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_exit_before_start_percentage', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_exit_before_start_percentage'] = $ad_exit_before_start_percentage;

        return $this;
    }

    /**
     * Gets long_resume
     *
     * @return bool|null
     */
    public function getLongResume()
    {
        return $this->container['long_resume'];
    }

    /**
     * Sets long_resume
     *
     * @param bool|null $long_resume long_resume
     *
     * @return self
     */
    public function setLongResume($long_resume)
    {

        if (is_null($long_resume)) {
            throw new \InvalidArgumentException('non-nullable long_resume cannot be null');
        }

        $this->container['long_resume'] = $long_resume;

        return $this;
    }

    /**
     * Gets long_rebuffering
     *
     * @return bool|null
     */
    public function getLongRebuffering()
    {
        return $this->container['long_rebuffering'];
    }

    /**
     * Sets long_rebuffering
     *
     * @param bool|null $long_rebuffering long_rebuffering
     *
     * @return self
     */
    public function setLongRebuffering($long_rebuffering)
    {

        if (is_null($long_rebuffering)) {
            throw new \InvalidArgumentException('non-nullable long_rebuffering cannot be null');
        }

        $this->container['long_rebuffering'] = $long_rebuffering;

        return $this;
    }

    /**
     * Gets playback_failure_error_type_id
     *
     * @return int|null
     */
    public function getPlaybackFailureErrorTypeId()
    {
        return $this->container['playback_failure_error_type_id'];
    }

    /**
     * Sets playback_failure_error_type_id
     *
     * @param int|null $playback_failure_error_type_id playback_failure_error_type_id
     *
     * @return self
     */
    public function setPlaybackFailureErrorTypeId($playback_failure_error_type_id)
    {

        if (is_null($playback_failure_error_type_id)) {
            array_push($this->openAPINullablesSetToNull, 'playback_failure_error_type_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('playback_failure_error_type_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['playback_failure_error_type_id'] = $playback_failure_error_type_id;

        return $this;
    }

    /**
     * Gets playback_business_exception_error_type_id
     *
     * @return int|null
     */
    public function getPlaybackBusinessExceptionErrorTypeId()
    {
        return $this->container['playback_business_exception_error_type_id'];
    }

    /**
     * Sets playback_business_exception_error_type_id
     *
     * @param int|null $playback_business_exception_error_type_id playback_business_exception_error_type_id
     *
     * @return self
     */
    public function setPlaybackBusinessExceptionErrorTypeId($playback_business_exception_error_type_id)
    {

        if (is_null($playback_business_exception_error_type_id)) {
            array_push($this->openAPINullablesSetToNull, 'playback_business_exception_error_type_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('playback_business_exception_error_type_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['playback_business_exception_error_type_id'] = $playback_business_exception_error_type_id;

        return $this;
    }

    /**
     * Gets video_startup_business_exception_error_type_id
     *
     * @return int|null
     */
    public function getVideoStartupBusinessExceptionErrorTypeId()
    {
        return $this->container['video_startup_business_exception_error_type_id'];
    }

    /**
     * Sets video_startup_business_exception_error_type_id
     *
     * @param int|null $video_startup_business_exception_error_type_id video_startup_business_exception_error_type_id
     *
     * @return self
     */
    public function setVideoStartupBusinessExceptionErrorTypeId($video_startup_business_exception_error_type_id)
    {

        if (is_null($video_startup_business_exception_error_type_id)) {
            array_push($this->openAPINullablesSetToNull, 'video_startup_business_exception_error_type_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('video_startup_business_exception_error_type_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['video_startup_business_exception_error_type_id'] = $video_startup_business_exception_error_type_id;

        return $this;
    }

    /**
     * Gets playback_failure
     *
     * @return bool|null
     */
    public function getPlaybackFailure()
    {
        return $this->container['playback_failure'];
    }

    /**
     * Sets playback_failure
     *
     * @param bool|null $playback_failure playback_failure
     *
     * @return self
     */
    public function setPlaybackFailure($playback_failure)
    {

        if (is_null($playback_failure)) {
            throw new \InvalidArgumentException('non-nullable playback_failure cannot be null');
        }

        $this->container['playback_failure'] = $playback_failure;

        return $this;
    }

    /**
     * Gets ad_playback_failure_error_type_id
     *
     * @return int|null
     */
    public function getAdPlaybackFailureErrorTypeId()
    {
        return $this->container['ad_playback_failure_error_type_id'];
    }

    /**
     * Sets ad_playback_failure_error_type_id
     *
     * @param int|null $ad_playback_failure_error_type_id ad_playback_failure_error_type_id
     *
     * @return self
     */
    public function setAdPlaybackFailureErrorTypeId($ad_playback_failure_error_type_id)
    {

        if (is_null($ad_playback_failure_error_type_id)) {
            array_push($this->openAPINullablesSetToNull, 'ad_playback_failure_error_type_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_playback_failure_error_type_id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_playback_failure_error_type_id'] = $ad_playback_failure_error_type_id;

        return $this;
    }

    /**
     * Gets view_content_startup_time
     *
     * @return int|null
     */
    public function getViewContentStartupTime()
    {
        return $this->container['view_content_startup_time'];
    }

    /**
     * Sets view_content_startup_time
     *
     * @param int|null $view_content_startup_time view_content_startup_time
     *
     * @return self
     */
    public function setViewContentStartupTime($view_content_startup_time)
    {

        if (is_null($view_content_startup_time)) {
            array_push($this->openAPINullablesSetToNull, 'view_content_startup_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_content_startup_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_content_startup_time'] = $view_content_startup_time;

        return $this;
    }

    /**
     * Gets ad_preroll_startup_time
     *
     * @return int|null
     */
    public function getAdPrerollStartupTime()
    {
        return $this->container['ad_preroll_startup_time'];
    }

    /**
     * Sets ad_preroll_startup_time
     *
     * @param int|null $ad_preroll_startup_time ad_preroll_startup_time
     *
     * @return self
     */
    public function setAdPrerollStartupTime($ad_preroll_startup_time)
    {

        if (is_null($ad_preroll_startup_time)) {
            array_push($this->openAPINullablesSetToNull, 'ad_preroll_startup_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_preroll_startup_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_preroll_startup_time'] = $ad_preroll_startup_time;

        return $this;
    }

    /**
     * Gets ad_watch_time
     *
     * @return int|null
     */
    public function getAdWatchTime()
    {
        return $this->container['ad_watch_time'];
    }

    /**
     * Sets ad_watch_time
     *
     * @param int|null $ad_watch_time ad_watch_time
     *
     * @return self
     */
    public function setAdWatchTime($ad_watch_time)
    {

        if (is_null($ad_watch_time)) {
            array_push($this->openAPINullablesSetToNull, 'ad_watch_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ad_watch_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['ad_watch_time'] = $ad_watch_time;

        return $this;
    }

    /**
     * Gets view_content_watch_time
     *
     * @return int|null
     */
    public function getViewContentWatchTime()
    {
        return $this->container['view_content_watch_time'];
    }

    /**
     * Sets view_content_watch_time
     *
     * @param int|null $view_content_watch_time view_content_watch_time
     *
     * @return self
     */
    public function setViewContentWatchTime($view_content_watch_time)
    {

        if (is_null($view_content_watch_time)) {
            array_push($this->openAPINullablesSetToNull, 'view_content_watch_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('view_content_watch_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['view_content_watch_time'] = $view_content_watch_time;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


